package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.reform.majorProjects.manager.PilotQuantitativeObjectivesPushManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectives;
import com.artfess.reform.majorProjects.manager.PilotQuantitativeObjectivesManager;

import javax.annotation.Resource;
import java.util.Arrays;

/**
 * 改革方案明确的量化目标表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@RestController
@RequestMapping("/majorProjects/pilotQuantitativeObjectives/v1/")
@Api(tags = "市级重大改革项目管理-改革方案明确的量化目标")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PilotQuantitativeObjectivesController extends BaseController<PilotQuantitativeObjectivesManager, PilotQuantitativeObjectives> {


    @Resource
    public PilotQuantitativeObjectivesPushManager pilotQuantitativeObjectivesPushManager;


    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        // 验证删除
        int count = pilotQuantitativeObjectivesPushManager.countQuantitativeObjectivesPush(id);
        if(count > 0){
            throw new BaseException("目标已经在推进中，不能删除该目标！");
        }
        boolean result = baseService.removeById(id);
        return CommonResult.success(id, "删除成功！");
    }

}
