package com.artfess.reform.majorProjects.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotProjectFillManager;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 市级重大改革项目填报审核记录 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
@RestController
@RequestMapping("/majorProjects/bizPilotProjectFill/v1/")
@Api(tags = "市级重大改革项目管理-填报审核记录")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PilotProjectFillController extends BaseController<PilotProjectFillManager, PilotProjectFill> {


    @Resource
    private PilotProjectFillManager pilotProjectFillManager;

    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;

    @PostMapping(value="/queryPageFillList", produces={"application/json; charset=utf-8" })
    @ApiOperation("根据流程类型分页查询项目最新的流程填报情况")
    public PageList<PilotProjectFill> queryPageFillList(@RequestBody QueryFilter<PilotProjectFill> queryFilter,
                                                        @ApiParam(name = "isAffirm", value = "是否确认环节（true：是，false：不是）")@RequestParam(name = "isAffirm",required = true) Boolean isAffirm,
                                                        @ApiParam(name = "flowType", value = "流程类型（1：量化目标审核流程2：月度计划审核流程，3：经验推广流程，4：品牌显示度流程）")@RequestParam(name = "flowType",required = true) Integer flowType) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !isAffirm) {
            queryFilter.addFilter("p.UNIT_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        if(flowType!=2){
            queryFilter.addFilter("p.send_status_", 1, QueryOP.EQUAL);
        }
        queryFilter.addFilter("p.is_dele_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("p.closing_", 1, QueryOP.EQUAL);
        queryFilter.addFilter("p.project_Type_", 1, QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("a.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return baseService.queryPageFillList(queryFilter,flowType);
    }


    @PostMapping(value="/queryPageFillGroup", produces={"application/json; charset=utf-8" })
    @ApiOperation("专项小组根据流程类型分页查询项目最新的流程填报情况")
    public PageList<PilotProjectFill> queryPageFillList(@RequestBody QueryFilter<PilotProjectFill> queryFilter,
                                                        @ApiParam(name = "flowType", value = "流程类型（1：量化目标审核流程2：月度计划审核流程，3：经验推广流程，4：品牌显示度流程）")@RequestParam(name = "flowType",required = true) Integer flowType,
                                                        @ApiParam(name = "code", value = "角色code")@RequestParam(name = "code",required = false) String code) {
        IUser user = ContextUtil.getCurrentUser();
        if (user.isAdmin()) {
            code=null;
        }
        if(flowType!=2){
            queryFilter.addFilter("p.send_status_", 1, QueryOP.EQUAL);
        }
        queryFilter.addFilter("p.is_dele_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("p.closing_", 1, QueryOP.EQUAL);
        queryFilter.addFilter("p.project_Type_", 1, QueryOP.EQUAL);

        return baseService.queryPageFillGroup(queryFilter,flowType,code);
    }


    /**
     * 审批数据创建接口
     * @param pilotProjectFillCreateVo
     * @return
     */
//    @PutMapping("/saveVo")
//    @ApiOperation("审批-保存草稿数据接口")
//    public CommonResult<String> saveVo(@RequestBody PilotProjectFillCreateVo pilotProjectFillCreateVo) {
//        pilotProjectFillManager.saveVo(pilotProjectFillCreateVo);
//        return CommonResult.success(pilotProjectFillCreateVo.getPilotProjectFill().getProjectId(), "数据保存成功");
//    }
//
//    /**
//     * 审批数据提交接口
//     * @param pilotProjectFillCreateVo
//     * @return
//     */
//    @PutMapping("/commitVo")
//    @ApiOperation("审批-提交审核数据接口")
//    public CommonResult<String> commitVo(@RequestBody PilotProjectFillCreateVo pilotProjectFillCreateVo) {
//        PilotProjectFill pilotProjectFill = pilotProjectFillCreateVo.getPilotProjectFill();
//        pilotProjectFillManager.commitVo(pilotProjectFillCreateVo);
//        return CommonResult.success(pilotProjectFill == null? null : pilotProjectFill.getProjectId(), "数据保存成功");
//    }

    /**
     * 审批数据领导审核接口
     * @param fillPushExamineVo
     * @return
     */
//    @PutMapping("/examineVo")
//    @ApiOperation("审批-领导审核数据接口")
//    public CommonResult<String> examineVo(@RequestBody FillPushExamineVo fillPushExamineVo) {
//        pilotProjectFillManager.examineVo(fillPushExamineVo);
//        return CommonResult.success(fillPushExamineVo.getId(), "数据提交成功");
//    }
//
//    /**
//     * 审批数据分页查询接口
//     * @param queryFilter
//     * @return
//     */
//    @PostMapping("/queyrList")
//    @ApiOperation("审核-分页查询审核数据")
//    public PageList<PilotProjectFillQueryVo> queyrList(@RequestBody QueryFilter<PilotProjectFill> queryFilter) {
//
//        return pilotProjectFillManager.queyrList(queryFilter);
//    }
//
//
//    /**
//     * 审批数据查询详情
//     * @param id
//     * @return
//     */
//    @GetMapping("/getDetails")
//    @ApiOperation("审核-根据ID查询审核数据详情")
//    public PilotProjectFillQueryVo getDetails(@ApiParam(name = "id", value = "填报审核记录ID") @RequestParam(required = true) String id) {
//        return pilotProjectFillManager.getDetails(id);
//    }
//
//    /**
//     * 根据ID查询审核历史数据详情,如果ID为空则查询上一次的审批记录详情
//     * @param projectId
//     * @return
//     */
//    @GetMapping("/getHistoryDetails")
//    @ApiOperation("审核-根据projectId查询上一次审核的数据详情")
//    public PilotProjectFillQueryVo getHistoryDetails(@ApiParam(name = "projectId", value = "项目ID")
//                                                         @RequestParam(required = true) String projectId) {
//
//        return pilotProjectFillManager.getHistoryDetails(projectId);
//    }

//    /**
//     * 审批数据查询上一次填的草稿详情，如果没有则返回空对象
//     *
//     * @return
//     */
//    @GetMapping("/getDraftDetails")
//    @ApiOperation(value = "审核-查询上一次填报保存的草稿详情", notes = "查询上一次填报保存的草稿详,没有草稿数据则返回空对象")
//    public PilotProjectFillQueryVo getDraftDetails(@ApiParam(name = "projectId", value = "项目ID")
//                                                       @RequestParam(required = true) String projectId ) {
//        return pilotProjectFillManager.getDraftDetails(projectId);
//    }


//    /**
//     * 审批填报初始化目录、举措、计划等接口，如果上次已经填写了草稿则将上一次的草稿查询出来
//     * @param pilotProjectFill
//     * @return
//     */
//    @PostMapping("/examineInit")
//    @ApiOperation("审批填报初始化-根据项目projectId查询项目关联信息")
//    public MunicipalMajorProjectManagementVo getExamineById(@RequestBody PilotProjectFill pilotProjectFill) {
////        municipalMajorProjectManagementManager.getExamineById(pilotProjectFill);
//        return municipalMajorProjectManagementManager.getExamineVoById(pilotProjectFill);
//    }
//    @PutMapping("/saveVo")
//    @ApiOperation("审批-保存草稿数据接口")
//    public CommonResult<String> saveVo(@RequestBody PilotProjectFillCreateVo pilotProjectFillCreateVo) {
//        pilotProjectFillManager.saveVo(pilotProjectFillCreateVo);
//        return CommonResult.success(pilotProjectFillCreateVo.getPilotProjectFill().getProjectId(), "数据保存成功");
//    }

//    /**
//     * 审批数据提交接口
//     * @param pilotProjectFillCreateVo
//     * @return
//     */
//    @PutMapping("/commitVo")
//    @ApiOperation("审批-提交审核数据接口")
//    public CommonResult<String> commitVo(@RequestBody PilotProjectFillCreateVo pilotProjectFillCreateVo) {
//        PilotProjectFill pilotProjectFill = pilotProjectFillCreateVo.getPilotProjectFill();
//        pilotProjectFillManager.commitVo(pilotProjectFillCreateVo);
//        return CommonResult.success(pilotProjectFill == null? null : pilotProjectFill.getProjectId(), "数据保存成功");
//    }
//
//    /**
//     * 审批数据领导审核接口
//     * @param fillPushExamineVo
//     * @return
//     */
//    @PutMapping("/examineVo")
//    @ApiOperation("审批-领导审核数据接口")
//    public CommonResult<String> examineVo(@RequestBody FillPushExamineVo fillPushExamineVo) {
//        pilotProjectFillManager.examineVo(fillPushExamineVo);
//        return CommonResult.success(fillPushExamineVo.getId(), "数据提交成功");
//    }

//    /**
//     * 审批数据分页查询接口
//     * @param queryFilter
//     * @return
//     */
//    @PostMapping("/queyrList")
//    @ApiOperation("审核-分页查询审核数据")
//    public PageList<PilotProjectFillQueryVo> queyrList(@RequestBody QueryFilter<PilotProjectFill> queryFilter) {
//
//        return pilotProjectFillManager.queyrList(queryFilter);
//    }
//
//
//    /**
//     * 审批数据查询详情
//     * @param id
//     * @return
//     */
//    @GetMapping("/getDetails")
//    @ApiOperation("审核-根据ID查询审核数据详情")
//    public PilotProjectFillQueryVo getDetails(@ApiParam(name = "id", value = "填报审核记录ID") @RequestParam(required = true) String id) {
//        return pilotProjectFillManager.getDetails(id);
//    }
//
//    /**
//     * 根据ID查询审核历史数据详情,如果ID为空则查询上一次的审批记录详情
//     * @param projectId
//     * @return
//     */
//    @GetMapping("/getHistoryDetails")
//    @ApiOperation("审核-根据projectId查询上一次审核的数据详情")
//    public PilotProjectFillQueryVo getHistoryDetails(@ApiParam(name = "projectId", value = "项目ID")
//                                                         @RequestParam(required = true) String projectId) {
//
//        return pilotProjectFillManager.getHistoryDetails(projectId);
//    }
//
//    /**
//     * 审批数据查询上一次填的草稿详情，如果没有则返回空对象
//     *
//     * @return
//     */
//    @GetMapping("/getDraftDetails")
//    @ApiOperation(value = "审核-查询上一次填报保存的草稿详情", notes = "查询上一次填报保存的草稿详,没有草稿数据则返回空对象")
//    public PilotProjectFillQueryVo getDraftDetails(@ApiParam(name = "projectId", value = "项目ID")
//                                                       @RequestParam(required = true) String projectId ) {
//        return pilotProjectFillManager.getDraftDetails(projectId);
//    }
//
//
//    /**
//     * 审批填报初始化目录、举措、计划等接口，如果上次已经填写了草稿则将上一次的草稿查询出来
//     * @param pilotProjectFill
//     * @return
//     */
//    @PostMapping("/examineInit")
//    @ApiOperation("审批填报初始化-根据项目projectId查询项目关联信息")
//    public MunicipalMajorProjectManagementVo getExamineById(@RequestBody PilotProjectFill pilotProjectFill) {
////        municipalMajorProjectManagementManager.getExamineById(pilotProjectFill);
//        return municipalMajorProjectManagementManager.getExamineVoById(pilotProjectFill);
//    }

    /**
     * 根据项目ID判断，是否有审核中的数据，true：有，false：没有
     * @param projectId
     * @return 是否有审核中的数据，true：有，false：没有
     */
//    @GetMapping("/haveExamine")
//    @ApiOperation(value = "根据项目ID判断是否有审核中的数据", httpMethod = "GET", notes = "根据项目ID判断是否有审核中的数据，true：有，false：没有")
//    public boolean haveExamine(@ApiParam(name = "projectId", value = "项目ID")
//                                                     @RequestParam(required = true) String projectId) {
//
//        return pilotProjectFillManager.haveExamine(projectId);
//    }

}
