package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.PilotProjectFillCreateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.model.PilotBrandPush;
import com.artfess.reform.majorProjects.manager.PilotBrandPushManager;

import java.util.List;

/**
 * 项目品牌显示度情况 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
@RestController
@RequestMapping("/majorProjects/bizPilotBrandPush/v1/")
@Api(tags = "市级重大改革项目管理-项目品牌显示度情况")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PilotBrandPushController extends BaseController<PilotBrandPushManager, PilotBrandPush> {
    @PostMapping("/save")
    @ApiOperation("添加实体类")
    public CommonResult<String> save(@RequestBody PilotProjectFillCreateVo pilotProjectFillCreateVo ) {
        baseService.insertInfo(pilotProjectFillCreateVo);
       return new CommonResult<>("添加成功");
    }

    @PostMapping("/update")
    @ApiOperation("更新实体类")
    public CommonResult<String> update(@RequestBody PilotProjectFillCreateVo pilotProjectFillCreateVo) {
        baseService.updateInfo(pilotProjectFillCreateVo);
        return new CommonResult<>("更新成功");
    }

    @PostMapping("/findByHis")
    @ApiOperation("根据项目id查询项目详情")
    public List<PilotProjectFill> findByHis(@RequestParam("id")String id) {
        return baseService.findByHis(id);
    }

    @PostMapping("/findById")
    @ApiOperation("根据项目查询子驾驶舱品牌详情")
    public PilotProjectFill findById(@RequestParam("id")String id,@RequestParam(value = "year",required = false)Integer year,@RequestParam(value = "month",required = false)Integer month) {
        return  baseService.findById(id,year,month);
    }

    @PostMapping("/updateByStatus")
    @ApiOperation("修改审核状态")
    public CommonResult<String> updateByStatus(@RequestBody PilotProjectFill entity) {
        boolean res = baseService.updateByStatus(entity);
        return new CommonResult<>(res?"修改成功":"修改失败");
    }
}
