package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectivesPush;
import com.artfess.reform.majorProjects.vo.MunicipalMajorProjectAllVo;
import com.artfess.reform.majorProjects.vo.PushCommitVo;
import com.artfess.reform.majorProjects.vo.PushExamineVo;
import com.artfess.reform.majorProjects.vo.QuantitativeObjectivesVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * 市级重大改革项目管理表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@RestController
@RequestMapping("/majorProjects/municipalMajorProjectManagement/v1/")
@Api(tags = "市级重大改革项目管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class MunicipalMajorProjectManagementController extends BaseController<MunicipalMajorProjectManagementManager, MunicipalMajorProjectManagement> {


    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;


    @GetMapping("/{id}")
    @ApiOperation("根据id查询实体")
    public MunicipalMajorProjectManagement getById(@ApiParam(name="id", value="实体id") @PathVariable(value = "id") String id) {
        return municipalMajorProjectManagementManager.getById(id);
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="实体集合") @RequestParam String...ids) {
        for(String id : ids){
           boolean result = baseService.removeById(id);
            if(!result) {
                return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
            }
        }
        return new CommonResult<>();
    }

    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除数据")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        municipalMajorProjectManagementManager.removeById(id);
        return CommonResult.success(id, "数据删除成功！");
    }

    @Override
    @PostMapping("/")
    @ApiOperation("添加数据接口")
    public CommonResult<String> create(@RequestBody MunicipalMajorProjectManagement municipalMajorProjectManagement) {
        municipalMajorProjectManagementManager.create(municipalMajorProjectManagement);
        return CommonResult.success(municipalMajorProjectManagement.getId(), "数据保存成功！");

    }

    @Override
    @PutMapping("/")
    @ApiOperation("修改数据接口")
    public CommonResult<String> updateById(@RequestBody MunicipalMajorProjectManagement municipalMajorProjectManagement) {
         municipalMajorProjectManagementManager.updateById(municipalMajorProjectManagement);
        return CommonResult.success(municipalMajorProjectManagement.getId(), "数据更新成功！");
    }

    @PostMapping("/list")
    @ApiOperation("不分页查询数据")
    public List<MunicipalMajorProjectManagement> list(@RequestBody QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
//        queryFilter.addFilter("PROJECT_TYPE_",1, QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("CLOSING_",1, QueryOP.EQUAL);
        List<MunicipalMajorProjectManagement> municipalMajorProjectManagements = municipalMajorProjectManagementManager.queryNoPage(queryFilter);
        return municipalMajorProjectManagements;
    }

    @PostMapping("/queryProjectList")
    @ApiOperation("分页查询所有项目信息（不分类型）")
    public PageList<MunicipalMajorProjectManagement> queryProjectList(@RequestBody QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("CLOSING_",1, QueryOP.EQUAL);
        PageList<MunicipalMajorProjectManagement> queryList= municipalMajorProjectManagementManager.queryProjectList(queryFilter);
        return queryList;
    }

    @Override
    @PostMapping("/query")
    @ApiOperation("分页查询数据")
    public PageList<MunicipalMajorProjectManagement> query(@RequestBody QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("CLOSING_",1, QueryOP.EQUAL);
        PageList<MunicipalMajorProjectManagement> queryList= municipalMajorProjectManagementManager.query(queryFilter);
        return queryList;
    }

    @PostMapping("/queryList")
    @ApiOperation("带权限分页查询数据")
    public PageList<MunicipalMajorProjectManagement> queryList(@RequestBody QueryFilter<MunicipalMajorProjectManagement> queryFilter,@RequestParam(name = "isAffirm",required = true) Boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !isAffirm) {
            if(StringUtils.isNotBlank(ContextUtil.getCurrentOrgId())){
                queryFilter.addFilter("m.UNIT_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
            }
            queryFilter.addFilter("m.SEND_STATUS_",0, QueryOP.EQUAL);
        }
        queryFilter.addFilter("m.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("m.CLOSING_",1, QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("m.last_time_", Direction.DESC));
        queryFilter.setSorter(sorter);
        PageList<MunicipalMajorProjectManagement> queryList= municipalMajorProjectManagementManager.queryByPage(queryFilter);
        return queryList;
    }

    @PostMapping("/queryListGroup")
    @ApiOperation("专项小组带权限分页查询数据")
    public PageList<MunicipalMajorProjectManagement> queryListGroup(@RequestBody QueryFilter<MunicipalMajorProjectManagement> queryFilter,@RequestParam(name = "code",required = false) String code) {
        IUser user = ContextUtil.getCurrentUser();
        if (user.isAdmin() ) {
           code=null;
        }
        queryFilter.addFilter("m.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("m.CLOSING_",1, QueryOP.EQUAL);
        PageList<MunicipalMajorProjectManagement> queryList= municipalMajorProjectManagementManager.queryByPageGroup(queryFilter,code);
        return queryList;
    }

    @PostMapping("/queryAll")
    @ApiOperation("项目下拉菜单或者查询所有项目信息")
    public List<MunicipalMajorProjectManagement> queryAll(@RequestBody QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("PROJECT_TYPE_",1, QueryOP.EQUAL);
        queryFilter.addFilter("CLOSING_",1, QueryOP.EQUAL);
        List<MunicipalMajorProjectManagement> municipalMajorProjectManagements = municipalMajorProjectManagementManager.queryAll(queryFilter);
        return municipalMajorProjectManagements;
    }



    @PostMapping("/queryReserveProject")
    @ApiOperation("分页查询储备项目数据")
    public PageList<MunicipalMajorProjectManagement> queryReserveProject(@RequestBody QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("PROJECT_TYPE_",2, QueryOP.EQUAL, FieldRelation.AND,"typeFilterZ");
        queryFilter.addFilter("PROJECT_TYPE_",3, QueryOP.EQUAL, FieldRelation.OR, "typeFilterZ");
        queryFilter.addFilter("CLOSING_",1, QueryOP.EQUAL);
        PageList<MunicipalMajorProjectManagement> queryList= municipalMajorProjectManagementManager.query(queryFilter);
        return queryList;
    }



    @PostMapping("/queryIterationProject")
    @ApiOperation("分页查询项目数据-迭代审核项目列表")
    public PageList<MunicipalMajorProjectManagement> queryIterationProject(@RequestBody QueryFilter<MunicipalMajorProjectManagement> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("PROJECT_TYPE_",1, QueryOP.EQUAL);
        queryFilter.addFilter("CLOSING_",1, QueryOP.EQUAL);
        PageList<MunicipalMajorProjectManagement> queryList= municipalMajorProjectManagementManager.queryIterationProject(queryFilter);
        return queryList;
    }


    @PutMapping("/pushSave")
    @ApiOperation("目标推进情况、进度计划推进情况审核保存接口")
    public CommonResult<String> objectivesPushSave(@RequestBody PushCommitVo pushCommitVo) {
        municipalMajorProjectManagementManager.pushSave(pushCommitVo);
        return CommonResult.success(pushCommitVo, "数据保存成功！");
    }


    @PutMapping("/pushSaveAndCommit")
    @ApiOperation("目标推进情况、进度计划推进情况审核提交接口")
    public CommonResult<String> pushSaveAndCommit(@RequestBody PushCommitVo pushCommitVo) {
        municipalMajorProjectManagementManager.pushSaveAndCommit(pushCommitVo);
        return CommonResult.success(pushCommitVo, "数据保存成功！");
    }


    @PutMapping("/pushExamine")
    @ApiOperation("目标推进情况、进度计划推进情况审核接口")
    public CommonResult<String> pushExamine(@RequestBody PushExamineVo pushExamineVo) {
        municipalMajorProjectManagementManager.pushExamine(pushExamineVo);
        return CommonResult.success(pushExamineVo, "数据保存成功！");
    }


    @PostMapping("/isExists")
    @ApiOperation("目标推进情况、进度计划推进情况审核接口")
    public CommonResult<String> isExists(@RequestBody MunicipalMajorProjectManagement municipalMajorProjectManagement) {
        boolean res = municipalMajorProjectManagementManager.isExists(municipalMajorProjectManagement);
        if (!res){
            return new CommonResult<>(false,"已存在相同数据,无法继续添加相同内容");
        }
        return new CommonResult<>(true,"");
    }

    @PostMapping("/closeProject")
    @ApiOperation("关闭重大项目")
    public CommonResult<String> closeProject(@RequestParam String...ids) {
        boolean result = false;
        if(ids!=null && ids.length>0){
            List<String> idList = Arrays.asList(ids);
            UpdateWrapper<MunicipalMajorProjectManagement>  updateWrapper =new UpdateWrapper<>();
            updateWrapper.set("CLOSING_", 0).set("CLOSING_TIME_", LocalDateTime.now()).eq("STATUS_", 5).in("id_",idList);
            result = this.baseService.update(updateWrapper);
        }
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "关闭失败！");
        }
        return new CommonResult<>("关闭成功！");
    }

    @PostMapping("/updateStatus")
    @ApiOperation("修改重大项目的状态")
    public CommonResult<String> updateStatus(@RequestBody MunicipalMajorProjectManagement municipalMajorProjectManagement) {
        boolean b = municipalMajorProjectManagementManager.updateStatus(municipalMajorProjectManagement);
        if(!b) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "数据审核失败！");
        }
        return CommonResult.success(municipalMajorProjectManagement.getId(), "数据审核成功！");
    }

    @PostMapping("/revocation")
    @ApiOperation("撤销重大项目的前一步审核状态")
    public CommonResult<String> revocation(@ApiParam(name="id", value="项目ID") @RequestParam String id, @ApiParam(name="status", value="项目审核状态")  @RequestParam Integer status,
                                           @ApiParam(name="approvalResults", value="执行结果（0：同意，1：驳回，2：撤回）") @RequestParam(required = false) Integer approvalResults) {
        boolean b = municipalMajorProjectManagementManager.revocation(id,status,approvalResults);
        if(!b) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "数据撤销失败！");
        }
        return CommonResult.success(id,"数据撤销成功！");
    }


    @PostMapping("/sendProject")
    @ApiOperation("下发重大项目")
    public CommonResult<String> sendProject(@RequestParam(required = true) String projectId) {
        boolean b = municipalMajorProjectManagementManager.updateSendStatus(projectId);
        if(!b) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "项目下发失败！");
        }
        return CommonResult.success(projectId, "项目下发成功！");
    }

    @PostMapping("/overAllQuery")
    @ApiOperation("大屏查询-重大项目全部信息")
    public MunicipalMajorProjectAllVo overAllQuery(@RequestParam(required = true) String projectId, @RequestParam(required = true) Integer year, @RequestParam(required = true) Integer month){
      return baseService.overAllQuery(projectId, year, month);
    }

    @PostMapping("/userFetchProject")
    @ApiOperation("根据当前登录用户-查询项目重大项目")
    public List<MunicipalMajorProjectManagement> userFetchProject(){
        QueryWrapper<MunicipalMajorProjectManagement> queryWrapper=new QueryWrapper<>();
        if (!ContextUtil.getCurrentUser().isAdmin()){
            queryWrapper.eq("UNIT_ID_",ContextUtil.getCurrentOrgId());
        }
        queryWrapper.eq("IS_DELE_","0");
        return baseService.list(queryWrapper);
    }
}
