package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.reform.majorProjects.model.BizPilotNotStartProjectFill;
import com.artfess.reform.majorProjects.vo.FillPushExamineVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.model.BizPilotNotStartMeasuresPush;
import com.artfess.reform.majorProjects.manager.BizPilotNotStartMeasuresPushManager;

import java.util.List;

/**
 * 项目具体举措计划（月度计划）推进情况 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-10-17
 */
@RestController
@RequestMapping("/bizPilotNotStartMeasuresPush/v1/")
@Api(tags = "市级重大改革项目两个一批月度进展")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizPilotNotStartMeasuresPushController extends BaseController<BizPilotNotStartMeasuresPushManager, BizPilotNotStartMeasuresPush> {

    @PostMapping("/saveOrUpdateDate")
    @ApiOperation("添加或修改数据")
    public CommonResult saveOrUpdateDate(@RequestBody BizPilotNotStartProjectFill fill) {
        String id = fill.getId();
        boolean res = baseService.saveOrUpdateDate(fill);
        if (id!=null){
            return new CommonResult<>(res,res?"更新成功":"更新失败");
        }
        return new CommonResult<>(res,res?"添加成功":"添加失败");
    }

    @PostMapping("/findById/{projectId}")
    @ApiOperation("查询详情数据及历史数据")
    public List<BizPilotNotStartProjectFill> findById(@PathVariable("projectId")String projectId) {
        return baseService.findById(projectId);
    }

    @PostMapping("/updateById")
    @ApiOperation("修改审核状态")
    public CommonResult updateById(@RequestBody FillPushExamineVo fillVo) {
        boolean res = baseService.updateById(fillVo);
        return new CommonResult(res,res?"修改成功":"修改失败");
    }
}
