package com.artfess.reform.fill.vo;

import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class OneThingsVo {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "原始数据id")
    @TableField("ORIGINAL_ID_")
    private String originalId;

    @ApiModelProperty(value = "事项名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "事项类型")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "所属体系")
    @TableField("APPERTAIN_SYSTEM_")
    private Integer appertainSystem;

    @ApiModelProperty(value = "所属跑道")
    @TableField("APPERTAIN_SUNWAY_")
    private Integer appertainSunway;

    @ApiModelProperty(value = "事项简介")
    @TableField("BRIEF_INTRODUCTION_")
    private String briefIntroduction;

    @ApiModelProperty(value = "当前状态")
    @TableField("CURRENT_STATE_")
    private Integer currentState;

    @ApiModelProperty(value = "核准情况")
    @TableField("AUDIT_STATUS_")
    private Integer auditStatus;

    @ApiModelProperty(value = "核准原因")
    @TableField("CASE_")
    private String removeCase;

    @ApiModelProperty(value = "是否纳入名录库(0:是，1:否)")
    @TableField("IS_BRING_INTO_")
    private Integer isBringInto;

    @ApiModelProperty(value = "是否涉密")
    @TableField("ONE_CLASSIFIED_")
    private Integer oneClassified;

    @ApiModelProperty(value = "是否涉密")
    @TableField("TWO_CLASSIFIED_")
    private Integer twoClassified;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele="0";

    @ApiModelProperty(value = "入库时间")
    @TableField("AUDIT_TIME_")
    private LocalDateTime auditTime;

    @ApiModelProperty(value = "事项来源1.自主谋划 2.承接市级试点")
    @TableField("SOURCE_")
    private Integer source;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<DefaultFile> files;
}
