package com.artfess.reform.fill.vo;

import com.artfess.reform.fill.model.BizReformDemandAssignment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 改革需求分析-需求交办信息最新推进数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-03-07
 */

@ApiModel(value="DemandAssignmentVo对象", description="改革需求分析-需求交办信息最新推进数据")
@Data
public class DemandAssignmentVo extends BizReformDemandAssignment {

    @ApiModelProperty(value = "推进记录Id")
    private String recordId;

    @ApiModelProperty(value = "下一步工作计划")
    private String workPlan;

    @ApiModelProperty(value = "填报时间")
    private LocalDateTime reportingTime;

    @ApiModelProperty("是否涉密文件")
    private String classified;

}
