package com.artfess.reform.fill.vo;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.artfess.reform.fill.model.BizBlockageCardTransfer;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 堵点卡点交办推进记录Vo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */

@ApiModel(value="BizBlockageCardTransferVo对象", description="堵点卡点交办推进记录Vo")
@Data
public class BlockageCardTransferVo extends BizBlockageCardTransfer {

    @ApiModelProperty("是否涉密文件")
    private String classified;

    @ApiModelProperty(value = "填报时间")
    private LocalDateTime reportingTime;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;


    @ApiModelProperty("文件")
    @TableField(exist = false)
    private List<DefaultFile> files;

}
