package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 专项小组单位信息信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-05-15
 */
@Data
@TableName("BIZ_SPECIAL_GROUP_ORG")
@ApiModel(value="BizSpecialGroupOrg对象", description="专项小组单位信息信息")
public class BizSpecialGroupOrg extends BaseModel<BizSpecialGroupOrg> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "专项小组ID")
    @TableField("GROUP_ID_")
    private String groupId;

    @ApiModelProperty(value = "所属领域（使用字典，1：政治，2：经济，3：文化，4：社会，5：生态）")
    @TableField("GROUP_FIELD_")
    private Integer groupField;

    @ApiModelProperty(value = "成员类型(0:角色 1:主责单位，2：成员单位)")
    @TableField("MEMBER_TYPE_")
    private Integer memberType;


    @ApiModelProperty(value = "关联对象类型 org:机构 role:角色")
    @TableField("OBJECT_TYPE_")
    private String objectType;

    @ApiModelProperty(value = "成员单位ID")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "成员单位CODE")
    @TableField("ORG_CODE_")
    private String orgCode;

    @ApiModelProperty(value = "成员单位name")
    @TableField("ORG_NAME_")
    private String orgName;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Integer lastTime;

}
