package com.artfess.reform.fill.model;

import java.math.BigDecimal;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

/**
 * 项目改革满意度管理
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@TableName("BIZ_REFORM_SATISFACTION_PROJECT")
@ApiModel(value="BizReformSatisfactionProject对象", description="项目改革满意度管理")
@Data
public class BizReformSatisfactionProject extends AutoFillFullModel<BizReformSatisfactionProject> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "调查名称")
    @TableField("ESTIGATION_NAME_")
    private String estigationName;
    @ApiModelProperty(value = "调查年份")
    @TableField("SCORING_YEAR_")
    private Integer scoringYear;

    @ApiModelProperty(value = "调查季度")
    @TableField("SCORING_QUARTER_")
    private Integer scoringQuarter;

    @ApiModelProperty(value = "调查月份")
    @TableField("SCORING_MONTH_")
    private Integer scoringMonth;

    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @ApiModelProperty(value = "调查日期")
    @TableField("SCORING_DATE_")
    private Date scoringDate;

    @ApiModelProperty(value = "重大改革项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "重大项目ID")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private Integer classified;

    @ApiModelProperty(value = "满意度")
    @TableField("SATISFACTION_")
    private BigDecimal satisfaction;

    @ApiModelProperty(value = "调查结论")
    @TableField("INVESTIGATION_CONCLUSION_")
    private String investigationConclusion;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;
    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";


    @ApiModelProperty(value = "附件id")
    @TableField(exist = false)
    private List<String> ids;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<DefaultFile> fileList;

}
