package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
@TableName("biz_reform_satisfaction_management")
@ApiModel(value = "改革区县满意度管理")
public class BizReformSatisfactionManagement extends AutoFillFullModel<BizReformSatisfactionManagement> {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("ESTIGATION_NAME_")
    @ApiModelProperty(value = "调查名称")
    private String estigationName;

    @ApiModelProperty(value = "调查年份")
    @TableField("SCORING_YEAR_")
    private Integer scoringYear;

    @ApiModelProperty(value = "调查季度")
    @TableField("SCORING_QUARTER_")
    private Integer scoringQuarter;

    @ApiModelProperty(value = "调查月份")
    @TableField("SCORING_MONTH_")
    private Integer scoringMonth;

    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @TableField("SCORING_DATE_")
    @ApiModelProperty(value = "调查日期")
    private Date scoringDate;

    @TableField("CLASSIFIED_")
    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    private Integer classified;

    @TableField("INVESTIGATION_CONCLUSION_")
    @ApiModelProperty(value = "调查结论")
    private String investigationConclusion;

    @TableField("REMARKS_")
    @ApiModelProperty(value = "备注")
    private String remarks;

    @TableField("STATUS_")
    @ApiModelProperty(value = "审核状态（0：草稿，1：已录入待审核，2：录入组织领导审核驳回，3：录入组织领导审核通过，4.改革办审核驳回 5.改革办审核通过）")
    private Integer status=0;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @TableField("AUDIT_TIME_")
    @ApiModelProperty(value = "审核日期")
    private LocalDate auditTime;

    @TableField("FILE_STATUS_")
    @ApiModelProperty(value = "附件审核状态")
    private Integer fileStatus;

    @ApiModelProperty(value = "审批意见")
    @TableField(exist = false)
    private String approvalComments;


    @TableField(exist = false)
    @ApiModelProperty(value = "附件id")
    List<String> ids;

    @TableField(exist = false)
    @ApiModelProperty(value = "涉及区县表")
    List<BizReformSatisfactionDistricts> bizReformSatisfactionDistricts;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件id")
    List<DefaultFile> fileList;

    @ApiModelProperty(value = "本次更新时间")
    @TableField(exist = false)
    private LocalDate thisTime;

}
