package com.artfess.reform.fill.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 满意度区县结果表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-20
 */
@Data
@TableName("BIZ_REFORM_SATISFACTION_DISTRICTS")
@ApiModel(value="BizReformSatisfactionDistricts对象", description="满意度区县结果表")
public class BizReformSatisfactionDistricts extends BaseModel<BizReformSatisfactionDistricts> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "改革满意度表ID")
    @TableField("SATISFACTION_ID_")
    private String satisfactionId;

    @ApiModelProperty(value = "涉及区县单位ID（（关联组织机构表ID））")
    @TableField("UNIT_ID_")
    private String unitId;

    @Excel(name = "区县",column = "B")
    @ApiModelProperty(value = "涉及区县单位NAME（关联组织机构表NAME）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @Excel(name = "区县编码",column = "A")
    @ApiModelProperty(value = "涉及区县单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "涉及区县单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @Excel(name = "综合评价得分",column = "C")
    @ApiModelProperty(value = "综合评价得分")
    @TableField("SATISFACTION_")
    private BigDecimal satisfaction;

    @Excel(name = "经济社会发展领域评价得分",column = "D")
    @ApiModelProperty(value = "经济社会发展领域评价得分")
    @TableField("ECO_FIELD_")
    private BigDecimal ecoField;

    @Excel(name = "招商引资成效评价得分",column = "E")
    @ApiModelProperty(value = "招商引资成效评价得分")
    @TableField("ECO_ZS_")
    private BigDecimal ecoZs;

    @Excel(name = "就业创业环境评价得分",column = "F")
    @ApiModelProperty(value = "就业创业环境评价得分")
    @TableField("ECO_CY_")
    private BigDecimal ecoCy;

    @Excel(name = "医疗卫生服务评价得分",column = "G")
    @ApiModelProperty(value = "医疗卫生服务评价得分")
    @TableField("ECO_YL_")
    private BigDecimal ecoYl;

    @Excel(name = "教育环境评价得分",column = "H")
    @ApiModelProperty(value = "教育环境评价得分")
    @TableField("ECO_JY_")
    private BigDecimal ecoJy;

    @Excel(name = "生态环境评价得分",column = "I")
    @ApiModelProperty(value = "生态环境评价得分")
    @TableField("ECO_ST_")
    private BigDecimal ecoSt;

    @Excel(name = "民主政治领域评价得分",column = "J")
    @ApiModelProperty(value = "民主政治领域评价得分")
    @TableField("DEM_FIELD_")
    private BigDecimal demField;

    @Excel(name = "民主议事开展评价得分",column = "K")
    @ApiModelProperty(value = "民主议事开展评价得分")
    @TableField("DEM_YS_")
    private BigDecimal demYs;

    @Excel(name = "办事效率评价得分",column = "L")
    @ApiModelProperty(value = "办事效率评价得分")
    @TableField("DEM_BS_")
    private BigDecimal demBs;

    @Excel(name = "文化领域评价得分",column = "M")
    @ApiModelProperty(value = "文化领域评价得分")
    @TableField("CUL_FIELD_")
    private BigDecimal culField;

    @Excel(name = "艺术活动评价得分",column = "N")
    @ApiModelProperty(value = "文化、体育、艺术活动评价得分")
    @TableField("CUL_WH_")
    private BigDecimal culWh;

    @Excel(name = "爱国主义教育成效评价得分",column = "O")
    @ApiModelProperty(value = "爱国主义教育成效评价得分")
    @TableField("CUL_AG_")
    private BigDecimal culAg;

    @Excel(name = "平安法治领域评价得分",column = "P")
    @ApiModelProperty(value = "平安法治领域评价得分")
    @TableField("PEACE_FIELD_")
    private BigDecimal peaceField;

    @Excel(name = "司法机关公正司法评价得分",column = "Q")
    @ApiModelProperty(value = "司法机关公正司法评价得分")
    @TableField("PEACE_SF_")
    private BigDecimal peaceSf;

    @Excel(name = "社会治安状况评价得分",column = "R")
    @ApiModelProperty(value = "社会治安状况评价得分")
    @TableField("PEACE_ZA_")
    private BigDecimal peaceZa;

    @Excel(name = "党建统领领域评价得分",column = "S")
    @ApiModelProperty(value = "党建统领领域评价得分")
    @TableField("PARTY_FIELD_")
    private BigDecimal partyField;

    @Excel(name = "党政领导机关干部干事劲头和精神状态评价得分",column = "T")
    @ApiModelProperty(value = "党政领导机关干部干事劲头和精神状态评价得分")
    @TableField("PARTY_GB_")
    private BigDecimal partyGb;

    @Excel(name = "党员干部清廉从政评价得分",column = "U")
    @ApiModelProperty(value = "党员干部清廉从政评价得分")
    @TableField("PARTY_QL_")
    private BigDecimal partyQl;


    @Excel(name = "综合得分区域排名",column = "V")
    @ApiModelProperty(value = "综合得分区域排名")
    @TableField("REGION_SN_")
    private BigDecimal regionSn;

    @Excel(name = "综合得分全市排名",column = "W")
    @ApiModelProperty(value = "综合得分全市排名")
    @TableField("ALL_SN_")
    private Double allSn;

    @ApiModelProperty(value = "全市蝉联第一次数")
    @TableField("HOLD_NUM_")
    private Integer holdNum;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;


    @ApiModelProperty(value = "调查年份")
    @TableField(exist = false)
    private Integer scoringYear;

    @ApiModelProperty(value = "调查季度")
    @TableField(exist = false)
    private Integer scoringQuarter;

    @ApiModelProperty(value = "调查月份")
    @TableField(exist = false)
    private Integer scoringMonth;

    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @TableField(exist = false)
    @ApiModelProperty(value = "调查日期")
    private Date scoringDate;

    public BizReformSatisfactionDistricts( Integer scoringQuarter, String unitCode) {
        this.scoringQuarter = scoringQuarter;
        this.unitCode = unitCode;
        this.ecoField = new BigDecimal(0);
        this.demField = new BigDecimal(0);
        this.culField = new BigDecimal(0);
        this.peaceField = new BigDecimal(0);
        this.partyField = new BigDecimal(0);
    }

    public BizReformSatisfactionDistricts() {

    }
}
