package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
@TableName("BIZ_REFORM_RISK_MANAGEMENT")
@ApiModel(value="BizReformRiskManagement", description="项目项目风险管理表")
public class BizReformRiskManagement extends AutoFillFullModel<BizReformRiskManagement> {

    @TableId("ID_")
    @ApiModelProperty(value = "id")
    private String id;

    @TableField("RISK_NAME_")
    @ApiModelProperty(value = "风险标题")
    private String riskName;

    @TableField("RISK_TYPE_")
    @ApiModelProperty(value = "类别（使用字典，1：重大负面舆情，2：群里性事件")
    private Integer riskType;

    @TableField("SIGNIFICANT_")
    @ApiModelProperty(value = "涉及对象（使用字典，0：重大项目，1：区县）")
    private Integer significant;

    @TableField("RISK_LEVEL_")
    @ApiModelProperty(value = "风险程度（1：较大，2：重大，3：特别重大）")
    private Integer  riskLevel;

    @TableField("RISK_DETAIL_")
    @ApiModelProperty(value = "详情")
    private String  riskDetail;

    @TableField("STATUS_")
    @ApiModelProperty(value = "审核状态（0：草稿，1：已录入待审核，2：录入组织领导审核驳回，3：录入组织领导审核通过，4.改革办审核驳回 5.改革办审核通过）")
    private Integer  status;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】")
    @TableField("CLASSIFIED_")
    private Integer classified;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "风险发生年份")
    @TableField("RISK_YEAR_")
    private Integer riskYear;

    @ApiModelProperty(value = "风险发生季度")
    @TableField("RISK_QUARTER_")
    private Integer riskQuarter;

    @ApiModelProperty(value = "风险发生月度")
    @TableField("RISK_MONTH_")
    private Integer riskMonth;

    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @ApiModelProperty(value = "风险发生日期")
    @TableField("RISK_DATE_")
    private Date riskDate;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;


    @TableField(exist = false)
    @ApiModelProperty(value = "本次更新时间")
    private LocalDate thisTime;


    @ApiModelProperty(value = "涉及区县表对象集合")
    @TableField(exist = false)
   List<BizReformRiskInvolvedDistricts> bizReformRiskInvolvedDistrictsList;

    @ApiModelProperty(value = "文件id集")
    @TableField(exist = false)
    List<String> ids;

    @ApiModelProperty(value = "文件id集")
    @TableField(exist = false)
    List<DefaultFile> fileList;


    @ApiModelProperty(value = "审批意见")
    @TableField(exist = false)
    private String approvalComments;

}
