package com.artfess.reform.fill.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@TableName("BIZ_REFORM_RISK_INVOLVED_DISTRICTS")
@ApiModel(value="BizReformRiskInvolvedDistricts对象", description="风险管理-涉及区县表")
public class BizReformRiskInvolvedDistricts  {
    @TableId("ID_")
    @ApiModelProperty(value = "id")
    private String id;
    @TableField("RISK_ID_")
    @ApiModelProperty(value = "改革风险管理表ID（关联改革试点管理表")
    private String riskId;
    @TableField("SIGNIFICANT_")
    @ApiModelProperty(value = "涉及对象（使用字典，0：重大项目，1：区县）")
    private Integer significant;
    @TableField("OBJECT_ID_")
    @ApiModelProperty(value = "涉及区县单位ID（（关联组织机构表ID））")
    private String objectId;
    @TableField("OBJECT_NAME_")
    @ApiModelProperty(value = "涉及区县单位NAME（关联组织机构表NAME）")
    private String objectName;
    @TableField("UNIT_CODE_")
    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    private String unitCode;
    @TableField("UNIT_GRADE_")
    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    private String unitGrade;
    @TableField("TENANT_ID_")
    @ApiModelProperty(value = "租户ID")
    private String tenantId;

    @ApiModelProperty(value = "调查季度")
    @TableField(exist = false)
    private Integer riskQuarter;
    @TableField(exist = false)
    @ApiModelProperty(value = "类别（使用字典，1：重大负面舆情，2：群里性事件")
    private Integer riskTpye;
    @TableField(exist = false)
    @ApiModelProperty(value = "风险程度（1：较大，2：重大，3：特别重大）")
    private Integer  riskLevel;
}
