package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 区县自主探索改革项目管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-10
 */
@TableName("BIZ_REFORM_PROJECT_COUNTY")
@ApiModel(value="BizReformProjectCounty对象", description="区县自主探索改革项目管理表")
@Data
public class BizReformProjectCounty extends AutoFillFullModel<BizReformProjectCounty> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试点项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "部署时间")
    @TableField("DEPLOY_DATE_")
    private LocalDate deployDate;

    @ApiModelProperty(value = "所属领域（使用字典，1：政治，2：经济，3：文化，4：社会，5：生态）")
    @TableField("DEMAND_FIELD_")
    private Integer demandField;

    @ApiModelProperty(value = "所属跑道（使用字典，1：党的建设，2：XX）")
    @TableField("DEMAND_RUNWAY_")
    private Integer demandRunway;

    @ApiModelProperty(value = "改革需求")
    @TableField("DEMAND_CONTENT_")
    private String demandContent;

    @ApiModelProperty(value = "总体目标")
    @TableField("OBJECTIVE_")
    private String objective;

    @ApiModelProperty(value = "主要举措")
    @TableField("MEASURES_")
    private String measures;

    @ApiModelProperty(value = "进度详情")
    @TableField("PROGRESS_")
    private String progress;

    @ApiModelProperty(value = "主要成果")
    @TableField("RESULT_")
    private String result;

    @ApiModelProperty(value = "牵头市领导")
    @TableField("LEADER_")
    private String leader;

    @ApiModelProperty(value = "责任单位NAME（关联组织机构表名称）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "是否结项（0：已结项，1：未结项，结项后数据将不再在驾驶舱上面展示）")
    @TableField("CLOSING_")
    private Integer closing;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";




}
