package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.artfess.reform.fill.vo.PilotAdvanceResultNumVo;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
@TableName("BIZ_REFORM_PILOT_MANAGEMENT")
@ApiModel(value = "BizReformPilotManagement对象", description = "改革试点管理表")
public class BizReformPilotManagement extends AutoFillFullModel<BizReformPilotManagement> {

    @TableId("ID_")
    @ApiModelProperty(value = "主键_ID")
    private String id;

    @TableField("DOC_NO_")
    @ApiModelProperty(value = "试点项目文号")
    private String docNo;

    @TableField("DOC_NAME_")
    @ApiModelProperty(value = "试点项目字号")
    private String docName;

    @TableField("DOC_YEAR_")
    @ApiModelProperty(value = "试点项目年份")
    private Integer docYear;

    @TableField("DOC_NUM_")
    @ApiModelProperty(value = "试点项目号数")
    private Integer docNum;

    @TableField("DOCUMENT_BASIS_")
    @ApiModelProperty(value = "文件依据")
    private String documentBasis;

    @TableField("PILOT_PROJECT_NAME_")
    @ApiModelProperty(value = "试点项目名称")
    private String pilotProjectName;

    @TableField("PILOT_LEVEL_")
    @ApiModelProperty(value = "试点层级（使用字典，1：国家级，2：市级）")
    private Integer pilotLevel;

    @TableField("PILOT_FIELD_")
    @ApiModelProperty(value = "所属领域使用字典ggbb_ssly，1：党建统领，2：经济发展，3：社会民生，4：文化建设，5：平安法治， 6: 民主法制")
    private Integer pilotField;

    @TableField("PILOT_RUNWAY_")
    @ApiModelProperty(value = "所属跑道")
    private Integer pilotRunway;

    @TableField("PILOT_SUPERVISOR_")
    @ApiModelProperty(value = "主管部委（使用级联字典，与试点层级级联，1：外交部，2：国防部，3：发展改革委，请自行百度搜索全的）")
    private Integer pilotSupervisor;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("START_TIME_")
    @ApiModelProperty(value = "开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("ACCEPTANCE_TIME_")
    @ApiModelProperty(value = "完成时间")
    private Date acceptanceTime;

//    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
//    @TableField("ACTUAL_TIME_")
//    @ApiModelProperty(value = "开始时间")
//    private Date actualTime;

    @TableField("PILOT_TARGET_")
    @ApiModelProperty(value = "试点目标")
    private String pilotTarget;

    @TableField("TASK_DETAILS_")
    @ApiModelProperty(value = "任务详情")
    private String taskDetails;

    @TableField("PROPULSIVE_DETAILS_")
    @ApiModelProperty(value = "推进详情")
    private String propulsiveDetails;

    @TableField("UNIT_ID_")
    @ApiModelProperty(value = "主要责任单位ID（关联组织机构表ID）")
    private String UnitId;

    @TableField("UNIT_NAME_")
    @ApiModelProperty(value = "主要责任单位NAME（关联组织机构表名称）")
    private String UnitName;

    @TableField("UNIT_CODE_")
    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    private String UnitCode;

    @TableField("UNIT_GRADE_")
    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    private String UnitGrade;

    @TableField("STATUS_")
    @ApiModelProperty(value = "审核状态（审核状态（0：草稿，1：已录入待审核，2：主管部门领导确认驳回，3：主管部门领导确认通过【区县待更新】，4：区县已更新，5：已完成，子表更新为已完成时自动更新为已完成）")
    private Integer status;

    @TableField("TIME_PERIOD_")
    @ApiModelProperty(value = "时间期限0：长期,1:限时")
    private Integer timePeriod;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private Integer classified;

    @TableField("PROPULSIVE_STATUS_")
    @ApiModelProperty(value = "推进状态")
    private Integer propulsiveStatus;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele = "0";

    @TableField(exist = false)
    @ApiModelProperty(value = "推进信息表id")
    private String rid;

    @TableField(exist = false)
    @ApiModelProperty(value = "审批意见")
    private String approvalComments;

    @TableField(exist = false)
    @ApiModelProperty(value = "项目推进记录表状态")
    private Integer recordsStatus;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件id集合")
    private List<String> ids;

    @TableField(exist = false)
    @ApiModelProperty(value = "涉及区县集合")
    private List<BizReformInvolvedDistricts> invs;

    @TableField(exist = false)
    @ApiModelProperty(value = "涉及单位ID（关联组织机构表ID）")
    private String invsUnitId;

    @TableField(exist = false)
    @ApiModelProperty(value = "涉及单位NAME（关联组织机构表名称）")
    private String invsUnitName;

    @TableField(exist = false)
    @ApiModelProperty(value = "涉及单位CODE（关联组织机构表编码）")
    private String invsUnitCode;

    @TableField(exist = false)
    @ApiModelProperty(value = "涉及单位GRADE（关联组织机构表级别）")
    private String invsUnitGrade;

    @ApiModelProperty(value = "下一步工作计划")
    @TableField(exist = false)
    private String workPlan;

    @ApiModelProperty(value = "存在问题")
    @TableField(exist = false)
    private String existingProblems;

    @ApiModelProperty(value = "已开展工作")
    @TableField(exist = false)
    private String propulDetails;

    @ApiModelProperty(value = "成果名称")
    @TableField(exist = false)
    private String resultName;

    @ApiModelProperty(value = "成果解决问题")
    @TableField(exist = false)
    private String resultSolveProblem;

    @ApiModelProperty(value = "成果运转实效")
    @TableField(exist = false)
    private String resultActualEffect;

    @ApiModelProperty(value = "成果推进表推进状态")
    @TableField(exist = false)
    private  Integer ancPropulsiveStatus;

    @ApiModelProperty(value = "各区县实际验收时间")
    @TableField(exist = false)
    private  String  invActualTime;

    @ApiModelProperty(value = "主管部委文本")
    @TableField(exist = false)
    private String pilotSupervisorText;

    @ApiModelProperty(value = "试点层级文本")
    @TableField(exist = false)
    private String pilotLevelText;

    @ApiModelProperty(value = "所属领域文本")
    @TableField(exist = false)
    private String pilotFieldText;

    @ApiModelProperty(value = "所属跑道文本")
    @TableField(exist = false)
    private String pilotRunwayText;

    @ApiModelProperty(value = "推进状态文本")
    @TableField(exist = false)
    private String propulsiveStatusText;

    @TableField(exist = false)
    @ApiModelProperty(value = "未验收原因")
    private String cause;

    @TableField(exist = false)
    @ApiModelProperty(value = "成果集合")
    private List<BizPilotAdvanceResult> resultList;

    @TableField(exist = false)
    @ApiModelProperty(value = "项目成果统计数据集合")
    private List<PilotAdvanceResultNumVo> resultNumList;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField(exist = false)
    private Integer iterClassified;

    @TableField(exist = false)
    @ApiModelProperty(value = "修改验收时间-附件集合")
    private List<DefaultFile> iterFiles;

    @ApiModelProperty(value = "需迭代的时间期限")
    @TableField(exist = false)
    private Integer iterTimePeriod;

    @TableField(exist = false)
    @ApiModelProperty(value = "迭代状态")
    private Integer iterStatus;

    @TableField(exist = false)
    @ApiModelProperty(value = "迭代id")
    private String iterId;

    @TableField(exist = false)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "需迭代的验收时间")
    private Date iterAcceptanceTime;

}
