package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;

import java.util.Date;
import java.math.BigInteger;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 改革试点市级部门管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@TableName("BIZ_REFORM_PILOT_CITY_MANAGEMENT")
@ApiModel(value="BizReformPilotCityManagement对象", description="改革试点市级部门管理表")
@Data
public class BizReformPilotCityManagement extends AutoFillFullModel<BizReformPilotCityManagement> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试点项目名称")
    @TableField("PILOT_PROJECT_NAME_")
    private String pilotProjectName;

    @ApiModelProperty(value = "试点范围")
    @TableField("PILOT_RANGE_")
    private String pilotRange;

    @ApiModelProperty(value = "试点文件字号")
    @TableField("DOC_NAME_")
    private String docName;

    @ApiModelProperty(value = "试点文件年份")
    @TableField("DOC_YEAR_")
    private Integer docYear;

    @ApiModelProperty(value = "试点文件号数")
    @TableField("DOC_NUM_")
    private Integer docNum;

    @ApiModelProperty(value = "试点文件文号（例如：渝党委[2023]11号）")
    @TableField("DOC_NO_")
    private String docNo;

    @ApiModelProperty(value = "文件依据")
    @TableField("DOCUMENT_BASIS_")
    private String documentBasis;

    @ApiModelProperty(value = "市级牵头部门")
    @TableField("LEAD_UNIT_NAME_")
    private String leadUnitName;

    @ApiModelProperty(value = "国家级主管部委（使用级联字典，与试点层级级联，1：外交部，2：国防部，3：发展改革委，请自行百度搜索全的）")
    @TableField("PILOT_SUPERVISOR_")
    private String pilotSupervisor;

    @ApiModelProperty(value = "所属领域（使用字典，1：政治，2：经济，3：文化，4：社会，5：生态）")
    @TableField("PILOT_FIELD_")
    private Integer pilotField;

    @ApiModelProperty(value = "专项小组名称")
    @TableField("GROUP_NAME_")
    private String groupName;

    @ApiModelProperty(value = "所属跑道（使用字典，1：党的建设，2：XX）")
    @TableField("PILOT_RUNWAY_")
    private Integer pilotRunway;

    @ApiModelProperty(value = "责任单位ID")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "责任单位NAME（关联组织机构表名称）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "时间期限(0:长期 1:限期)")
    @TableField("TIME_PERIOD_")
    private Integer timePeriod;

    @ApiModelProperty(value = "开始时间")
    @TableField("START_TIME_")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty(value = "验收时间")
    @TableField("ACCEPTANCE_TIME_")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date acceptanceTime;

    @ApiModelProperty(value = "试点目标")
    @TableField("PILOT_TARGET_")
    private String pilotTarget;

    @ApiModelProperty(value = "任务详情")
    @TableField("TASK_DETAILS_")
    private String taskDetails;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private Integer classified;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "推进id")
    @TableField(exist = false)
    private String recId;

    @ApiModelProperty(value = "审核状态")
    @TableField(exist = false)
    private Integer status;


    @ApiModelProperty(value = "推进状态（使用字典：2：推进中，3：已验收）")
    @TableField(exist = false)
    private Integer propulsiveStatus;

    @ApiModelProperty(value = "实际验收日期")
    @TableField(exist = false)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualTime;

    @ApiModelProperty(value = "下一步工作计划")
    @TableField(exist = false)
    private String workPlan;

    @ApiModelProperty(value = "存在问题")
    @TableField(exist = false)
    private String existingProblems;

    @ApiModelProperty(value = "推进详情")
    @TableField(exist = false)
    private String propulsiveDetails;

    @ApiModelProperty(value = "成果形式（使用字典：可多选，1：形成制度成果，2：搭建工作平台，3：上线应用场景，4：其他）")
    @TableField(exist = false)
    private Integer resultForm;

    @ApiModelProperty(value = "成果名称")
    @TableField(exist = false)
    private String resultName;

    @ApiModelProperty(value = "成果形成日期")
    @TableField(exist = false)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date resultDate;

    @ApiModelProperty(value = "解决问题")
    @TableField(exist = false)
    private String solveProblem;

    @ApiModelProperty(value = "运转实效")
    @TableField(exist = false)
    private String actualEffect;


    @ApiModelProperty(value = "成果描述")
    @TableField(exist = false)
    private String resultDes;

    @ApiModelProperty(value = "基本信息表附件集合")
    @TableField(exist = false)
    private List<DefaultFile> files;

    @ApiModelProperty(value = "推进信息及试点成果")
    @TableField(exist = false)
    private BizPilotAdvanceCityRecord record;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField(exist = false)
    private Integer iterClassified;

    @TableField(exist = false)
    @ApiModelProperty(value = "修改验收时间-附件集合")
    private List<DefaultFile> iterFiles;

    @ApiModelProperty(value = "需迭代的时间期限")
    @TableField(exist = false)
    private Integer iterTimePeriod;

    @TableField(exist = false)
    @ApiModelProperty(value = "迭代状态")
    private Integer iterStatus;

    @TableField(exist = false)
    @ApiModelProperty(value = "迭代数据id")
    private String iterId;

    @TableField(exist = false)
    @ApiModelProperty(value = "未验收原因")
    private String cause;

    @TableField(exist = false)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty(value = "需迭代的验收时间")
    private Date iterAcceptanceTime;
}
