package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 改革需求分析-需求交办表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
@TableName("BIZ_REFORM_DEMAND_ASSIGNMENT")
@ApiModel(value="BizReformDemandAssignment对象", description="改革需求分析-需求交办表")
@Data
public class BizReformDemandAssignment extends AutoFillFullModel<BizReformDemandAssignment> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "需求库id关联改革需求分析需求库表id，当选择的是需求库的数据时自动带入后面的字段")
    @TableField("DEMAND_ANALYSIS_LIBRARY_ID_")
    private String demandAnalysisLibraryId;

    @ApiModelProperty(value = "需求题目")
    @TableField("DEMAND_TOPIC_")
    private String demandTopic;

    @ApiModelProperty(value = "需求描述")
    @TableField("DEMAND_DESCRIPTION_")
    private String demandDescription;

    @ApiModelProperty(value = "来源渠道使用字典，1：习近平总书记重要指示精神，2：群众企业基层所盼")
    @TableField("DEMAND_SOURCE_CHANNEL_")
    private Integer demandSourceChannel;

    @ApiModelProperty(value = "所属领域使用字典，1：政治，2：经济，3：文化，4：社会，5：生态")
    @TableField("DEMAND_FIELD_")
    private Integer demandField;

    @ApiModelProperty(value = "所属跑道使用字典，1：党的建设，2：xx")
    @TableField("DEMAND_RUNWAY_")
    private Integer demandRunway;

    @ApiModelProperty(value = "主要责任单位类型（1：市级部门，2：区县，当选择的主要责任单位的级别为1时，类型为1，其余为2，级别由前端传入）")
    @TableField("RESPONSIBLE_UNIT_TYPE_")
    private String responsibleUnitType;

    @ApiModelProperty(value = "主要责任单位id关联组织机构表id")
    @TableField("RESPONSIBLE_UNIT_ID_")
    private String responsibleUnitId;

    @ApiModelProperty(value = "主要责任单位name关联组织机构表名称")
    @TableField("RESPONSIBLE_UNIT_NAME_")
    private String responsibleUnitName;

    @ApiModelProperty(value = "主责单位code")
    @TableField("RESPONSIBLE_UNIT_CODE_")
    private String responsibleUnitCode;

    @ApiModelProperty(value = "主责单位grade")
    @TableField("RESPONSIBLE_UNIT_GRADE_")
    private String responsibleUnitGrade;

    @ApiModelProperty(value = "协同单位name")
    @TableField("COOPERATIVE_UNIT_NAME_")
    private String cooperativeUnitName;

    @ApiModelProperty(value = "审议通过会议名称")
    @TableField("MEETING_NAME_")
    private String meetingName;

    @ApiModelProperty(value = "审议通过会议日期")
    @TableField("MEETING_DATE_")
    private LocalDate meetingDate;

    @ApiModelProperty(value = "需求清单期号")
    @TableField("DEMAND_NO_")
    private String demandNo;

    @ApiModelProperty(value = "需求交办季度")
    @TableField("PROPULSIVE_QUARTER_")
    private Integer propulsiveQuarter;

    @ApiModelProperty(value = "需求交办年份")
    @TableField("PROPULSIVE_YEAR_")
    private Integer propulsiveYear;

    @ApiModelProperty(value = "需求交办月份")
    @TableField("PROPULSIVE_MONTH_")
    private Integer propulsiveMonth;

    @ApiModelProperty(value = "反馈时限")
    @TableField("FEEDBACK_TIME_LIMIT_")
    private LocalDate feedbackTimeLimit;

    @ApiModelProperty(value = "需求状态使用字典：1：未启动，2：推进中，3：已完成")
    @TableField("DEMAND_STATUS_")
    private Integer demandStatus;

    @ApiModelProperty(value = "主责单位推进状态使用字典，子表审核通过后自动更新本状态：1：未启动，2：推进中，3：已完成")
    @TableField("PROPULSIVE_STATUS_")
    private Integer propulsiveStatus;

    @ApiModelProperty(value = "主责单位推进详情子表审核通过后自动更新本字段")
    @TableField("PROPULSIVE_DETAILED_")
    private String propulsiveDetailed;

    @ApiModelProperty(value = "主责单位存在问题，子表审核通过后自动更新本字段")
    @TableField("EXISTING_PROBLEMS_")
    private String existingProblems;

    @ApiModelProperty(value = "主责单位状态最后更新时间")
    @TableField("PROPULSIVE_UPDATE_DATE_")
    private LocalDateTime propulsiveUpdateDate;

    @ApiModelProperty(value = "更新状态后端字段，0：已更新，1：未更新")
    @TableField("PROPULSIVE_UPDATE_STATUS_")
    private Integer propulsiveUpdateStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;


    @ApiModelProperty(value = "最新推进记录的审核状态（0：草稿，1：已录入待更新，2：审核驳回，3：审核通过改革办待审核 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成）")
    @TableField(exist = false)
    private String status;

    @ApiModelProperty(value = "类别1：主责单位 2：协同单位'")
    @TableField(exist = false)
    private String maiinType;

    @ApiModelProperty(value = "推进记录条数")
    @TableField(exist = false)
    private Integer recordSize;

    @ApiModelProperty(value = "本次更新时间")
    @TableField(exist = false)
    private LocalDate thisTime;

    @ApiModelProperty("推进记录")
    @TableField(exist = false)
    private List<BizReformDemandAssignmentRecord> records;

    @ApiModelProperty("责任单位、协同单位表")
    @TableField(exist = false)
    private List<BizProjectCooperativeUnit> coordination;


}
