package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.joda.time.LocalDateTime;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.Date;

/**
 * 改革需求分析-需求库表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
@Data
@TableName("BIZ_REFORM_DEMAND_ANALYSIS_LIBRARY")
@ApiModel(value="BizReformDemandAnalysisLibrary对象", description="改革需求分析-需求库表")
public class BizReformDemandAnalysisLibrary extends AutoFillFullModel<BizReformDemandAnalysisLibrary> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "需求题目")
    @TableField("DEMAND_TOPIC_")
    private String demandTopic;

    @ApiModelProperty(value = "需求描述")
    @TableField("DEMAND_DESCRIPTION_")
    private String demandDescription;

    @ApiModelProperty(value = "来源渠道使用字典ggbb_lyqd，1：党中央国务院有要求，2：重庆发展有堵点、3：群众企业基层有期盼、4：先进省市有经验")
    @TableField("DEMAND_SOURCE_CHANNEL_")
    private Integer demandSourceChannel;

    @ApiModelProperty(value = "所属领域使用字典ggbb_ssly，1：党建统领，2：经济发展，3：社会民生，4：文化建设，5：平安法治， 6: 民主法制")
    @TableField("DEMAND_FIELD_")
    private Integer demandField;

    @ApiModelProperty(value = "所属跑道使用字典，1：党的建设，2：xx")
    @TableField("DEMAND_RUNWAY_")
    private Integer demandRunway;

    @ApiModelProperty(value = "采用状态使用字典，1：纳入需求全量库，2：纳入需求清单交办，3：转化为市级重大改革项目，4：不予采纳")
    @TableField("DEMAND_ADOPTION_STATUS_")
    private Integer demandAdoptionStatus;

    @ApiModelProperty(value = "审核状态0：草稿，1：已上报待审核，2：审核驳回，3：审核通过改革办待审核 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "上报单位_id")
    @TableField("REPORT_UNIT_ID_")
    private String reportUnitId;

    @ApiModelProperty(value = "上报单位_name")
    @TableField("REPORT_UNIT_NAME_")
    private String reportUnitName;

    @ApiModelProperty(value = "需求上报单位CODE（关联组织机构表编码）")
    @TableField("RESPONSIBLE_UNIT_CODE_")
    private String responsibleUnitCode;

    @ApiModelProperty(value = "需求上报单位GRADE（关联组织机构表级别）")
    @TableField("RESPONSIBLE_UNIT_GRADE_")
    private String responsibleUnitGrade;

    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @ApiModelProperty(value = "需求上报日期")
    @TableField("DEMAND_DATE_")
    private Date demandDate;

    @ApiModelProperty(value = "需求上报年份")
    @TableField("DEMAND_YEAR_")
    private Integer demandYear;

    @ApiModelProperty(value = "需求上报月份")
    @TableField("DEMAND_MONTH_")
    private Integer demandMonth;

    @ApiModelProperty(value = "需求上报季度")
    @TableField("DEMAND_QUARTER_")
    private Integer demandQuarter;

    @ApiModelProperty(value = "需求审核日期")
    @TableField("AUDIT_DATE_")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date auditDate;

    @ApiModelProperty(value = "需求审核年份")
    @TableField("AUDIT_YEAR_")
    private Integer auditYear;

    @ApiModelProperty(value = "需求审核季度")
    @TableField("AUDIT_QUARTER_")
    private Integer auditQuarter;

    @ApiModelProperty(value = "需求审核月份")
    @TableField("AUDIT_MONTH_")
    private Integer auditMonth;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户id")
    @TableField("TENANT_ID_")
    private String tenantId;

    @ApiModelProperty(value = "审批意见")
    @TableField(exist = false)
    private String approvalComments;

    @ApiModelProperty(value = "操作步骤0：通过 1：驳回 2：撤回")
    @TableField(exist = false)
    private Integer approvalResults;

    @ApiModelProperty(value = "本次更新时间")
    @TableField(exist = false)
    private LocalDate thisTime;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }


}
