package com.artfess.reform.fill.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 责任单位、协同单位表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
@TableName("BIZ_PROJECT_COOPERATIVE_UNIT")
@ApiModel(value="BizProjectCooperativeUnit对象", description="责任单位、协同单位表")
@Data
public class BizProjectCooperativeUnit extends BaseModel<BizProjectCooperativeUnit> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目id关联各个项目主表")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "类别1：主责单位 2：协同单位")
    @TableField("MAIIN_TYPE_")
    private Integer maiinType;

    @ApiModelProperty(value = "单位id（关联组织机构表id）")
    @TableField("COOPERATIVE_UNIT_ID_")
    private String cooperativeUnitId;

    @ApiModelProperty(value = "单位name关联组织机构表name")
    @TableField("COOPERATIVE_UNIT_NAME_")
    private String cooperativeUnitName;

    @ApiModelProperty(value = "单位code")
    @TableField("RESPONSIBLE_UNIT_CODE_")
    private String responsibleUnitCode;

    @ApiModelProperty(value = "单位grade")
    @TableField("RESPONSIBLE_UNIT_GRADE_")
    private String responsibleUnitGrade;



}
