package com.artfess.reform.fill.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


import java.time.LocalDate;
import java.util.List;

@Data
@TableName("BIZ_PILOT_ADVANCE_RESULT")
@ApiModel(value="试点项目推进记录成果表")
public class BizPilotAdvanceResult extends BaseModel<BizPilotAdvanceResult> {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试点ID（关联各个试点主表）")
    @TableField("PILOT_ID_")
    private String pilotId;

    @ApiModelProperty(value = "推进记录ID")
    @TableField("RECORD_ID_")
    private String recordId;

    @ApiModelProperty(value = "成果形式（使用字典：1：形成制度成果，2：搭建工作平台，3：上线应用场景，4：其他）")
    @TableField("RESULT_FORM_")
    private Integer resultForm;

    @ApiModelProperty(value = "成果名称")
    @TableField("RESULT_NAME_")
    private String resultName;

    @ApiModelProperty(value = "成果形成日期")
    @TableField("RESULT_DATE_")
    private LocalDate resultDate;

    @ApiModelProperty(value = "解决问题")
    @TableField("SOLVE_PROBLEM_")
    private String solveProblem;

    @ApiModelProperty(value = "运转实效")
    @TableField("ACTUAL_EFFECT_")
    private String actualEffect;

    @ApiModelProperty(value = "成果形成年份")
    @TableField("RESULT_YEAR_")
    private Integer resultYear;

    @ApiModelProperty(value = "成果形成季度")
    @TableField("RESULT_QUARTER_")
    private Integer resultQuarter;

    @ApiModelProperty(value = "成果形成月度")
    @TableField("RESULT_MONTH_")
    private Integer resultMonth;

    @ApiModelProperty(value = "成果描述")
    @TableField("RESULT_DES_")
    private String resultDes;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private Integer classified;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @TableField(exist = false)
    @ApiModelProperty(value = "试点项目名称")
    private String pilotProjectName;

    @ApiModelProperty(value = "涉及区县单位ID（（关联组织机构表ID））")
    @TableField(exist = false)
    private String unitId;

    @ApiModelProperty(value = "涉及区县单位NAME（关联组织机构表NAME）")
    @TableField(exist = false)
    private String unitName;

    @ApiModelProperty(value = "涉及区县单位CODE（关联组织机构表编码）")
    @TableField(exist = false)
    private String unitCode;

    @ApiModelProperty(value = "涉及区县单位GRADE（关联组织机构表级别）")
    @TableField(exist = false)
    private String unitGrade;


    @ApiModelProperty(value = "试点层级")
    @TableField(exist = false)
    private String pilotLevel;

    @TableField(exist = false)
    @ApiModelProperty(value = "附件集合")
    List<String> ids;


    @TableField(exist = false)
    @ApiModelProperty(value = "附件对象集合")
    List<DefaultFile> fileList;


}
