package com.artfess.reform.fill.model;

import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 改革试点市级部门推进记录成果表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@TableName("BIZ_PILOT_ADVANCE_CITY_RESULT")
@ApiModel(value="BizPilotAdvanceCityResult对象", description="改革试点市级部门推进记录成果表")
@Data
public class BizPilotAdvanceCityResult extends BaseModel<BizPilotAdvanceCityResult> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试点ID（关联各个试点主表）")
    @TableField("PILOT_ID_")
    private String pilotId;

    @ApiModelProperty(value = "推进记录ID")
    @TableField("RECORD_ID_")
    private String recordId;

    @ApiModelProperty(value = "成果形式（使用字典：可多选，1：形成制度成果，2：搭建工作平台，3：上线应用场景，4：其他）")
    @TableField("RESULT_FORM_")
    private Integer resultForm;

    @ApiModelProperty(value = "成果名称")
    @TableField("RESULT_NAME_")
    private String resultName;

    @ApiModelProperty(value = "成果形成日期")
    @TableField("RESULT_DATE_")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date resultDate;

    @ApiModelProperty(value = "解决问题")
    @TableField("SOLVE_PROBLEM_")
    private String solveProblem;

    @ApiModelProperty(value = "运转实效")
    @TableField("ACTUAL_EFFECT_")
    private String actualEffect;

    @ApiModelProperty(value = "成果形成年份")
    @TableField("RESULT_YEAR_")
    private Integer resultYear;

    @ApiModelProperty(value = "成果形成季度")
    @TableField("RESULT_QUARTER_")
    private Integer resultQuarter;

    @ApiModelProperty(value = "成果形成月度")
    @TableField("RESULT_MONTH_")
    private Integer resultMonth;

    @ApiModelProperty(value = "成果描述")
    @TableField("RESULT_DES_")
    private String resultDes;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private Integer classified;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "试点成果附件")
    @TableField(exist = false)
    private List<DefaultFile> files;

}
