package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * @Description:会议议定事项推进表
 * @Author: Rong Tao
 * @Date: 2023/4/3 17:11
 */
@Data
@TableName("BIZ_MEETING_EVENT_PUSH")
@ApiModel(value="BizMeetingEventPush对象", description="会议议定事项推进表")
public class BizMeetingEventPush extends AutoFillFullModel<BizMeetingEventPush> {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议事项ID")
    @TableField("MEETING_EVENT_ID_")
    private String meetingEventId;

    @ApiModelProperty(value = "会议事项详情ID")
    @TableField("DETAILS_ID_")
    private String detailsId;

    @ApiModelProperty(value = "反馈的日期")
    @TableField("FEEDBACK_DATE_")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date feedbackDate;

    @ApiModelProperty(value = "反馈的年度")
    @TableField("FEEDBACK_YEAR_")
    private Integer feedbackYear;

    @ApiModelProperty(value = "反馈的季度")
    @TableField("FEEDBACK_QUARTER_")
    private Integer feedbackQuarter;

    @ApiModelProperty(value = "反馈的月度")
    @TableField("FEEDBACK_MONTH_")
    private Integer feedbackMonth;

    @ApiModelProperty(value = "反馈的周数")
    @TableField("FEEDBACK_WEEK_")
    private Integer feedbackWeek;

    @ApiModelProperty(value = "责任单位ID")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "责任单位NAME（关联组织机构表名称）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "落实举措")
    @TableField("MEASURES_")
    private String measures;

    @ApiModelProperty(value = "当前进度")
    @TableField("PROGRESS_")
    private String progress;

    @ApiModelProperty(value = "推进状态（后端字段，1：未启动，2：推进中，3：已完成）")
    @TableField("ABUTMENT_STATUS_")
    private Integer abutmentStatus;

    @ApiModelProperty(value = "审核状态（0：草稿，1：已录入待更新，2：审核驳回，3：审核通过）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private String classified;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    private List<DefaultFile> files;

    @ApiModelProperty(value = "会议类型（字典1：六届市委深改委会议，2：全面深化改革推进会，3：全面深化改革调度会，4：数字重庆建设领导小组会议，5：数字重庆建设推进会，6：数字重庆建设工作调度会））")
    @TableField(exist = false)
    private String meetingType;

    @ApiModelProperty(value = "会议次别")
    @TableField(exist = false)
    private Integer meetingNum;

    @ApiModelProperty(value = "会议名称")
    @TableField(exist = false)
    private String meetingName;

    @ApiModelProperty(value = "会议时间")
    @TableField(exist = false)
    private LocalDate meetingTime;

    @ApiModelProperty(value = "驳回意见")
    @TableField(exist = false)
    private String approvalComments;

    @ApiModelProperty(value = "执行结果（0：同意，1：驳回，2：撤回）")
    @TableField(exist = false)
    private Integer approvalResults;
}
