package com.artfess.reform.fill.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会议交办详情协同配合单位表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-04-13
 */
@TableName("BIZ_MEETING_EVENT_DETAILS_UNIT")
@ApiModel(value="BizMeetingEventDetailsUnit对象", description="会议交办详情协同配合单位表")
@Data
public class BizMeetingEventDetailsUnit extends BaseModel<BizMeetingEventDetailsUnit> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "交办事项详情ID")
    @TableField("EVENT_DETAILS_ID_")
    private String eventDetailsId;

    @ApiModelProperty(value = "交办事项ID")
    @TableField("EVENT_ID_")
    private String eventId;

    @ApiModelProperty(value = "单位类型")
    @TableField("UNIT_TYPE_")
    private String unitType;

    @ApiModelProperty(value = "单位ID（（关联组织机构表ID））")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "单位NAME（关联组织机构表NAME）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId="-1";

}
