package com.artfess.reform.fill.model;


import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * @Description:会议议定事项详情表
 * @Author: Rong Tao
 * @Date: 2023/4/3 17:11
 */
@Data
@TableName("BIZ_MEETING_EVENT_DETAILS")
@ApiModel(value="BizMeetingEventDetails对象", description="会议议定事项详情表")
public class BizMeetingEventDetails extends BaseModel<BizMeetingEventDetails> {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议事项ID")
    @TableField("MEETING_EVENT_ID_")
    private String meetingEventId;

    @ApiModelProperty(value = "重点工作/领导讲话")
    @TableField("MEETING_TASK_")
    private String meetingTask;

    @ApiModelProperty(value = "具体任务")
    @TableField("SPECIFIC_TASK_")
    private String specificTask;

    @ApiModelProperty(value = "主要责任单位名称")
    @TableField("MIAN_UNIT_NAME_")
    private String mainUnitName;

    @ApiModelProperty(value = "专项小组名称")
    @TableField("GROUP_NAME_")
    private String groupName;

    @ApiModelProperty(value = "协同单位名称")
    @TableField("COOPERATIVE_UNIT_NAME_")
    private String cooperativeUnitName;

    @ApiModelProperty(value = "时间期限(0:长期 1:限期)")
    @TableField("TIME_PERIOD_")
    private Integer timePeriod;

    @ApiModelProperty(value = "更新频率（选择长期时候：W：每周更新，M：每月更新，Q：每季度更新）")
    @TableField("UPDATE_RATE_")
    private String updateRate;

    @ApiModelProperty(value = "反馈时限")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("FEEDBACK_TIME_LIMIT_")
    private Date feedbackTimeLimit;

    @ApiModelProperty(value = "推进状态（后端字段，1：未启动，2：推进中，3：已完成）")
    @TableField("ABUTMENT_STATUS_")
    private Integer abutmentStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;


    @JsonIgnore
    @ApiModelProperty(value = "最后更新时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="LAST_TIME_", fill=FieldFill.INSERT_UPDATE, select=false)
    private Long lastTime;

    @ApiModelProperty(value = "责任单位名称")
    @TableField(exist = false)
    private String unitName;

    @ApiModelProperty(value = "责任单位id")
    @TableField(exist = false)
    private String unitId;

    @ApiModelProperty(value = "责任单位Grade")
    @TableField(exist = false)
    private String unitGrade;

    @ApiModelProperty(value = "责任单位Code")
    @TableField(exist = false)
    private String unitCode;

    @ApiModelProperty(value = "单位类型 1：责任单位 2：配合单位")
    @TableField(exist = false)
    private String unitType;

    @ApiModelProperty(value = "会议类型（字典1：六届市委深改委会议，2：全面深化改革推进会，3：全面深化改革调度会，4：数字重庆建设领导小组会议，5：数字重庆建设推进会，6：数字重庆建设工作调度会））")
    @TableField(exist = false)
    private String meetingType;

    @ApiModelProperty(value = "会议次别")
    @TableField(exist = false)
    private Integer meetingNum;

    @ApiModelProperty(value = "会议名称")
    @TableField(exist = false)
    private String meetingName;

    @ApiModelProperty(value = "会议时间")
    @TableField(exist = false)
    private LocalDate meetingTime;

    @ApiModelProperty(value = "推进状态")
    @TableField(exist = false)
    private String pushId;

    @ApiModelProperty(value = "推进状态")
    @TableField(exist = false)
    private String pushStatus;

    @ApiModelProperty(value = "已开展工作及成效")
    @TableField(exist = false)
    private String measures;

    @ApiModelProperty(value = "存在的问题及困难")
    @TableField(exist = false)
    private String progress;

    @ApiModelProperty(value = "下步工作计划")
    @TableField(exist = false)
    private String workPlan;

    @ApiModelProperty(value = "推进数据集合")
    @TableField(exist = false)
    private List<BizMeetingEventPush> bizMeetingEventPushList;

    @ApiModelProperty(value = "审核状态（0：草稿，1：已录入待审核，2：审核驳回，3：审核通过）")
    @TableField(exist = false)
    private String status;

    @ApiModelProperty(value = "本次更新时间")
    @TableField(exist = false)
    private LocalDate thisTime;

    @ApiModelProperty(value = "会议交办详情主要责任单位表")
    @TableField(exist = false)
    private List<BizMeetingEventDetailsUnit> mainUnitList;

    @ApiModelProperty(value = "会议交办详情协同配合单位表")
    @TableField(exist = false)
    private List<BizMeetingEventDetailsUnit> bizMeetingEventDetailsUnitList;

}
