package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:会议议定事项表
 * @Author: Rong Tao
 * @Date: 2023/4/3 16:43
 */
@Data
@TableName("BIZ_MEETING_EVENT")
@ApiModel(value="BizMeetingEvent对象", description="会议议定事项表")
public class BizMeetingEvent extends AutoFillFullModel<BizMeetingEvent> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议类型（字典1：六届市委深改委会议，2：全面深化改革推进会，3：全面深化改革调度会，4：数字重庆建设领导小组会议，5：数字重庆建设推进会，6：数字重庆建设工作调度会，7:其他）")
    @TableField("MEETING_TYPE_")
    private String meetingType;

    @ApiModelProperty(value = "会议次别")
    @TableField("MEETING_NUM_")
    private Integer meetingNum;

    @ApiModelProperty(value = "会议名称")
    @TableField("MEETING_NAME_")
    private String meetingName;

    @ApiModelProperty(value = "会议时间")
    @TableField("MEETING_TIME_")
    private LocalDate meetingTime;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private String classified;

    @ApiModelProperty(value = "分发状态（0：未分发，1：已分发）")
    @TableField("SEND_STATUS_")
    private Integer sendStatus;

    @ApiModelProperty(value = "分发时间")
    @TableField(value="SEND_TIME_")
    private LocalDateTime sendTime;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableLogic
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    private List<DefaultFile> files;

    @ApiModelProperty(value = "会议议定事项推进数据集合")
    @TableField(exist = false)
    private List<BizMeetingEventDetails> bizMeetingEventDetailsList;

}
