package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会议审议通过文件处理推进表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-04-03
 */
@Data
@TableName("BIZ_MEETING_DOCUMENTS_PUSH")
@ApiModel(value="BizMeetingDocumentsPush对象", description="会议审议通过文件处理推进表")
public class BizMeetingDocumentsPush extends AutoFillFullModel<BizMeetingDocumentsPush> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议主表ID（关联各个会议主表）")
    @TableField("MEETING_ID_")
    private String meetingId;

    @ApiModelProperty(value = "责任单位ID")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "责任单位NAME（关联组织机构表名称）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "责任单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "责任单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "对接方式（使用字典，1：出台配配套文件，2：印发分工方案，3：直接执行文件，4：不涉及我市）")
    @TableField("ABUTMENT_TYPE_")
    private Integer abutmentType;

    @ApiModelProperty(value = "推进详情（需要上传推进详情作证材料）")
    @TableField("ABUTMENT_DETAILED_")
    private String abutmentDetailed;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private String classified;

    @ApiModelProperty(value = "推进状态(后端字段，1：未启动，2：推进中，3：已完成)")
    @TableField("ABUTMENT_STATUS_")
    private Integer abutmentStatus;

    @ApiModelProperty(value = "审核状态（0：草稿，1：已录入待更新，2：责任单位领导审核驳回，3：责任单位领导审核通过【改革办待审核】 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "审核通过时间")
    @TableField("PASS_TIME_")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date passTime;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";


    @ApiModelProperty(value = "执行结果（0：同意，1：驳回，2：撤回）")
    @TableField(exist = false)
    private Integer approvalResults;

    @ApiModelProperty(value = "驳回意见")
    @TableField(exist = false)
    private String approvalComments;

    @ApiModelProperty(value = "附件id")
    @TableField(exist = false)
    private List<String> ids;

    @ApiModelProperty(value = "附件文件集")
    @TableField(exist = false)
    private List<DefaultFile> files;

}
