package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会议审议通过文件管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@TableName("BIZ_MEETING_DOCUMENTS_CONSIDERED")
@ApiModel(value="BizMeetingDocumentsConsidered对象", description="会议审议通过文件管理表")
@Data
public class BizMeetingDocumentsConsidered extends AutoFillFullModel<BizMeetingDocumentsConsidered> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "文件名称")
    @TableField("FILE_NAME_")
    private String fileName;

    @ApiModelProperty(value = "会议类型（1：市深改委会议，2：中央深改委会议）")
    @TableField("MEETING_TYPE_")
    private Integer  meetingType;

    @ApiModelProperty(value = "会议名称")
    @TableField("MEETING_NAME_")
    private String meetingName;

    @ApiModelProperty(value = "审议时间")
    @TableField("REVIEW_TIME_")
    private LocalDate reviewTime;

    @ApiModelProperty(value = "反馈时限")
    @TableField("FEEDBACK_TIME_LIMIT_")
    private LocalDate feedbackTimeLimit;


    @ApiModelProperty(value = "是否涉密0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示涉密文件请从内部邮箱发送")
    @TableField("CLASSIFIED_")
    private String classified;

    @ApiModelProperty(value = "分发状态")
    @TableField("SEND_STATUS_")
    private Integer sendStatus;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "会议审议通过文件处理推进表对象")
    @TableField(exist = false)
    private List<BizMeetingDocumentsPush> pushs;

    @ApiModelProperty(value = "涉及区县表")
    @TableField(exist = false)
    private List<BizMeetingCooperativeUnit> invs;

    @ApiModelProperty(value = "责任单位id")
    @TableField(exist = false)
    private String unitId;

    @ApiModelProperty(value = "责任单位名称")
    @TableField(exist = false)
    private String unitName;

    @ApiModelProperty(value = "责任单位id")
    @TableField(exist = false)
    private String unitGrade;

    @ApiModelProperty(value = "责任单位名称")
    @TableField(exist = false)
    private String unitCode;

    @ApiModelProperty(value = "审核状态")
    @TableField(exist = false)
    private Integer status;

    @ApiModelProperty(value = "推进记录表id")
    @TableField(exist = false)
    private String pushId;

    @ApiModelProperty(value = "对接方式（使用字典，1：出台配配套文件，2：应发分工方案，3：直接执行文件，4：不涉及我市）")
    @TableField(exist = false)
    private Integer abutmentType;

    @ApiModelProperty(value = "对接详情")
    @TableField(exist = false)
    private String abutmentDetailed;

    @ApiModelProperty(value = "驳回意见")
    @TableField(exist = false)
    private String approvalComments;

    @ApiModelProperty(value = "推进状态")
    @TableField(exist = false)
    private Integer abutmentStatus;

    @ApiModelProperty(value = "执行结果（0：同意，1：驳回，2：撤回）")
    @TableField(exist = false)
    private Integer approvalResults;

    @ApiModelProperty(value = "本次更新时间")
    @TableField(exist = false)
    private LocalDate thisTime;
}
