package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会议责任单位、协同单位表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@TableName("BIZ_MEETING_COOPERATIVE_UNIT")
@ApiModel(value="BizMeetingCooperativeUnit对象", description="会议责任单位、协同单位表")
@Data
public class BizMeetingCooperativeUnit extends BaseModel<BizMeetingCooperativeUnit>{

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议主表id关联各个会议主表")
    @TableField("MEETING_ID_")
    private String meetingId;

    @ApiModelProperty(value = "类别1：主责单位 2：协同单位")
    @TableField("MAIIN_TYPE_")
    private Integer maiinType;

    @ApiModelProperty(value = "单位id（关联组织机构表id）")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "单位name关联组织机构表name")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "单位code关联组织机构表编码")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "单位grade关联组织机构表级别")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "租户id")
    @TableField("TENANT_ID_")
    private String tenantId;

}
