package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 围绕重点领域策划推出“一件事”情况
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */

@Data
@TableName("BIZ_DIGITAL_ONE_THING")
@ApiModel(value="BizDigitalOneThing对象", description="围绕重点领域策划推出“一件事”情况")
public class BizDigitalOneThing extends AutoFillFullModel<BizDigitalOneThing> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "原始数据id")
    @TableField("ORIGINAL_ID_")
    private String originalId;

    @ApiModelProperty(value = "事项名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "事项类型")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "所属体系")
    @TableField("APPERTAIN_SYSTEM_")
    private Integer appertainSystem;

    @ApiModelProperty(value = "所属跑道")
    @TableField("APPERTAIN_SUNWAY_")
    private Integer appertainSunway;

    @ApiModelProperty(value = "事项简介")
    @TableField("BRIEF_INTRODUCTION_")
    private String briefIntroduction;

    @ApiModelProperty(value = "当前状态")
    @TableField("CURRENT_STATE_")
    private Integer currentState;

    @ApiModelProperty(value = "核准情况")
    @TableField("AUDIT_STATUS_")
    private Integer auditStatus;

    @ApiModelProperty(value = "核准原因")
    @TableField("CASE_")
    private String removeCase;

//    @ApiModelProperty(value = "涉及市级部门组织id")
//    @TableField("UNIT_ID_")
//    private String unitId;
//
//    @ApiModelProperty(value = "涉及市级部门名称")
//    @TableField("UNIT_NAME_")
//    private String unitName;
//
//    @ApiModelProperty(value = "涉及市级部门code")
//    @TableField("UNIT_CODE_")
//    private String unitCode;
//
//    @ApiModelProperty(value = "涉及市级部门grade")
//    @TableField("UNIT_GRADE_")
//    private String unitGrade;

    @ApiModelProperty(value = "是否纳入名录库(0:是，1:否)")
    @TableField("IS_BRING_INTO_")
    private Integer isBringInto;

    @ApiModelProperty(value = "审核状态(与主表同步)")
    @TableField("UPDATE_STATUS_")
    private Integer updateStatus;

    @ApiModelProperty(value = "是否涉密")
    @TableField("ONE_CLASSIFIED_")
    private Integer oneClassified;

    @ApiModelProperty(value = "是否涉密")
    @TableField("TWO_CLASSIFIED_")
    private Integer twoClassified;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele="0";

    @ApiModelProperty(value = "入库时间")
    @TableField("AUDIT_TIME_")
    private LocalDateTime auditTime;

    @ApiModelProperty(value = "事项来源1.自主谋划 2.承接市级试点")
    @TableField("SOURCE_")
    private Integer source;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<DefaultFile> files;

    @ApiModelProperty(value = "状态")
    @TableField(exist = false)
    private Integer status;

    @ApiModelProperty(value = "是否更新(0.未更新，1.已更新)")
    @TableField(exist = false)
    private Integer isNow;

}
