package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * 推动数字重庆建设
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */

@Data
@TableName("BIZ_DIGITAL_CONSTRUCTION")
@ApiModel(value="BizDigitalConstruction对象", description="推动数字重庆建设")
public class    BizDigitalConstruction extends AutoFillFullModel<BizDigitalConstruction> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "区县名称")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "区县CODE")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "区县ID")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "区县GRADE")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "填报年份")
    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @ApiModelProperty(value = "填报日期")
    @TableField("FILL_DATE_")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fillDate;

    @ApiModelProperty(value = "填报月份")
    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @ApiModelProperty(value = "填报季度·")
    @TableField("FILL_QUARTER")
    private Integer fillQuarter;

    @ApiModelProperty(value = "审核状态(0:草稿,1:提交待审核 2:审核驳回 3:审核通过 4:改革办确认工单)")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableLogic
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "是否暂存")
    @TableField("IS_SAVE_")
    private Integer isSave;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField(exist = false)
    private List<BizDigitalAdvanceConstruction> bizDigitalAdvanceConstructionList;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField(exist = false)
    private List<BizDigitalOneThing> bizDigitalOneThingList;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField(exist = false)
    private List<BizDigitalThreeLists> bizDigitalThreeListsList;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField(exist = false)
    private List<BizDigitalOnLineApplication> bizDigitalOnLineApplicationList;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField(exist = false)
    private List<BizDigitalShareApplication> bizDigitalShareApplicationList;

}
