package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * 堵点卡点转交办表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
@TableName("BIZ_BLOCKAGE_CARD_TRANSFER")
@ApiModel(value="BizBlockageCardTransfer对象", description="堵点卡点转交办表")
@Data
public class BizBlockageCardTransfer extends AutoFillFullModel<BizBlockageCardTransfer> {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "需求库ID（关联改革需求分析-需求库表ID）")
    @TableField("DEMAND_ANALYSIS_LIBRARY_ID_")
    private String demandAnalysisLibraryId;

    @ApiModelProperty(value = "堵点卡点名称")
    @TableField("BLOCKAGE_CARD_TOPIC_")
    private String blockageCardTopic;

    @ApiModelProperty(value = "详细描述")
    @TableField("BLOCKAGE_CARD_DESCRIPTION_")
    private String blockageCardDescription;

    @ApiModelProperty(value = "来源渠道（使用字典，1：来源渠道1）")
    @TableField("BLOCKAGE_SOURCE_CHANNEL_")
    private Integer blockageSourceChannel;

    @ApiModelProperty(value = "所属领域（使用字典，1：政治，2：经济，3：文化，4：社会，5：生态）")
    @TableField("BLOCKAGE_FIELD_")
    private Integer blockageField;

    @ApiModelProperty(value = "所属跑道（使用字典，1：党的建设，2：XX）")
    @TableField("BLOCKAGE_RUNWAY_")
    private Integer blockageRunway;

    @ApiModelProperty(value = "堵点卡 出现日期")
    @TableField("BLOCKAGE_DATE_")
    private LocalDate blockageDate;

    @ApiModelProperty(value = "堵点卡 出现年份")
    @TableField("BLOCKAGE_YEAR_")
    private Integer blockageYear;

    @ApiModelProperty(value = "堵点卡 出现季度")
    @TableField("BLOCKAGE_QUARTER_")
    private Integer blockageQuarter;

    @ApiModelProperty(value = "堵点卡 出现月度")
    @TableField("BLOCKAGE_MONTH_")
    private Integer blockageMonth;

    @ApiModelProperty(value = "主要责任单位ID")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "主要责任单位NAME（关联组织机构表名称）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "反馈时限")
    @TableField("FEEDBACK_TIME_LIMIT_")
    private LocalDate feedbackTimeLimit;

    @ApiModelProperty(value = "推进状态（使用字典：2：推进中，3：已完成）")
    @TableField("PROPULSIVE_STATUS_")
    private Integer propulsiveStatus;

    @ApiModelProperty(value = "推进详情")
    @TableField("PROPULSIVE_DETAILED_")
    private String propulsiveDetailed;

    @ApiModelProperty(value = "存在问题")
    @TableField("EXISTING_PROBLEMS_")
    private String existingProblems;

    @ApiModelProperty(value = "主责单位状态最后更新时间")
    @TableField("PROPULSIVE_UPDATE_DATE_")
    private LocalDate propulsiveUpdateDate;

    @ApiModelProperty(value = "最后更新年份")
    @TableField("PROPULSIVE_YEAR_")
    private Integer propulsiveYear;

    @ApiModelProperty(value = "最后更新季度")
    @TableField("PROPULSIVE_QUARTER_")
    private Integer propulsiveQuarter;

    @ApiModelProperty(value = "最后更新月度")
    @TableField("PROPULSIVE_MONTH_")
    private Integer propulsiveMonth;

    @ApiModelProperty(value = "更新状态（后端字段，0：已更新，1：未更新）")
    @TableField("PROPULSIVE_UPDATE_STATUS_")
    private Integer propulsiveUpdateStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "审核状态0：草稿，1：已录入待更新，2：审核驳回，3：审核通过改革办待审核 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成")
    @TableField(exist = false)
    private Integer status;

    @ApiModelProperty(value = "推进记录数量")
    @TableField(exist = false)
    private Integer recordSize;

    @ApiModelProperty(value = "推进记录")
    @TableField(exist = false)
    private List<BizBlockageCardTransferRecord> records;
}
