package com.artfess.reform.fill.manager.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;
@Service
public class UniversalWayManagerImpl implements UniversalWayManager {
    @Resource
    FileManager fileManager;
    @Override
    public void attachmentUpdates(List<String> fileId,String bizId) {
        if (null!=fileId&&fileId.size()>0){
            fileManager.update(new UpdateWrapper<DefaultFile>().in("id_",fileId).set("biz_id_",bizId));
        }

    }

    @Override
    public Map<String, Integer> setLocalDate(LocalDate time) {
        Map<String, Integer> map=new HashMap<>();
        map.put("year",time.getYear());
        map.put("month",time.getMonthValue());
        map.put("quarter",(time.getMonthValue()+2)/3);
        map.put("week",time.getDayOfWeek().getValue());
        return map;
    }

    @Override
    public Map<String, Integer> setDate(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        HashMap<String, Integer> map = new HashMap<>();
        map.put("year",calendar.get(Calendar.YEAR));
        map.put("month",calendar.get(Calendar.MONTH)+1);
        int month = calendar.get(Calendar.MONTH) + 1;
        map.put("quarter",(month+2)/3);
        map.put("week",calendar.get(Calendar.WEEK_OF_YEAR));
        return map;
    }

    @Override
    @Transactional
    public void deleteFiles (String bizId){
        List<DefaultFile> fileIds = fileManager.queryFileByBizId(bizId);

        List<String> collect = fileIds.stream().map(DefaultFile::getId).collect(Collectors.toList());
        String[] strings=new String[collect.size()];
        try {
            fileManager.delSysFileByIds(collect.toArray(strings));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
