package com.artfess.reform.fill.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.fill.manager.BizSpecialGroupOrgManager;
import com.artfess.reform.fill.model.BizSpecialGroup;
import com.artfess.reform.fill.dao.BizSpecialGroupDao;
import com.artfess.reform.fill.manager.BizSpecialGroupManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.model.BizSpecialGroupOrg;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 专项小组信息信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-05-15
 */
@Service
public class BizSpecialGroupManagerImpl extends BaseManagerImpl<BizSpecialGroupDao, BizSpecialGroup> implements BizSpecialGroupManager {
@Resource
private BizSpecialGroupOrgManager bizSpecialGroupOrgManager;
    @Override
    @Transactional
    public boolean saveOrUpdateEntity(BizSpecialGroup bizSpecialGroup) {
        Assert.notNull(bizSpecialGroup,"对象不能为空");
        Assert.notNull(bizSpecialGroup.getBizSpecialGroupOrgList(),"专项小组单位信息不能为空");
        boolean res = super.saveOrUpdate(bizSpecialGroup);
        List<BizSpecialGroupOrg> groupOrgList = bizSpecialGroup.getBizSpecialGroupOrgList();
        List<String> ids = groupOrgList.stream().map(BizSpecialGroupOrg::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (bizSpecialGroup.getId()!=null){
            //删除多余责任单位和成员单位
            bizSpecialGroupOrgManager.remove(new QueryWrapper<BizSpecialGroupOrg>().notIn("ID_",ids).eq("GROUP_ID_",bizSpecialGroup.getId()));
        }
        //更新专项小组单位信息
        for (BizSpecialGroupOrg bizSpecialGroupOrg : groupOrgList) {
            bizSpecialGroupOrg.setGroupId(bizSpecialGroup.getId());
            bizSpecialGroupOrg.setGroupField(bizSpecialGroup.getGroupField());
        }
        bizSpecialGroupOrgManager.saveOrUpdateBatch(bizSpecialGroup.getBizSpecialGroupOrgList());
        return res;
    }

    @Override
    @Transactional
    public void deleteEntity(String id) {
        Assert.notNull(id,"需要删除的专项小组id不能为空");
        List<String> ids = Arrays.asList(id.split(","));
        //删除专项小组单位信息
        bizSpecialGroupOrgManager.remove(new QueryWrapper<BizSpecialGroupOrg>().in("GROUP_ID_",id));
        super.removeByIds(ids);
    }

    @Override
    public BizSpecialGroup findById(String id) {
        Assert.notNull(id,"需查询的专项小组id不能为空");
        BizSpecialGroup entity = super.getById(id);
        List<BizSpecialGroupOrg> bizSpecialGroupOrgList = bizSpecialGroupOrgManager.list(new QueryWrapper<BizSpecialGroupOrg>().eq("GROUP_ID_", entity.getId()));
        if (bizSpecialGroupOrgList!=null&&bizSpecialGroupOrgList.size()>0) entity.setBizSpecialGroupOrgList(bizSpecialGroupOrgList);
        return entity;
    }

    @Override
    public boolean isRepeat(String id, String name) {
        Assert.notNull(name,"专项小组名称不能为空");
        BizSpecialGroup entity = super.getOne(new QueryWrapper<BizSpecialGroup>().eq("GROUP_NAME_", name).eq("IS_DELE_", "0"));
        return entity==null||(id != null && id.equals(entity.getId()));
    }

    @Override
    public PageList<BizSpecialGroup> queryPageList(QueryFilter<BizSpecialGroup> queryFilter) {
        queryFilter.addFilter("o.MEMBER_TYPE_",1, QueryOP.EQUAL);
        IPage<BizSpecialGroup> iPage = baseMapper.queryPageList(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

}
