package com.artfess.reform.fill.manager.impl;


import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformWorkReport;
import com.artfess.reform.fill.dao.BizReformWorkReportDao;
import com.artfess.reform.fill.manager.BizReformWorkReportManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.vo.WorkReportNumVO;
import com.artfess.uc.api.impl.util.ContextUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.util.List;


/**
 * 工作报告管理 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@Service
public class BizReformWorkReportManagerImpl extends BaseManagerImpl<BizReformWorkReportDao, BizReformWorkReport> implements BizReformWorkReportManager {

    @Resource
    UniversalWayManager universalWayManager;


    @Override
    public boolean insertOrUpdateInfo(BizReformWorkReport bizReformWorkReport) {
        String mes = bizReformWorkReport.getId();
        this.saveOrUpdate(bizReformWorkReport);
        //更新附件上传项目id
        if(BeanUtils.isNotEmpty(bizReformWorkReport.getIds())){
            List<String> ids = bizReformWorkReport.getIds();
            universalWayManager.attachmentUpdates(ids,bizReformWorkReport.getId());
        }
        return mes==null;
    }

    @Override
    public void removeInfo(String ids) {
        String[] id = ids.split(",");
        for (String res : id) {
            //删除对应文件
            universalWayManager.deleteFiles(res);
            this.remove(res);
        }
    }


    @Override
    public PageList<BizReformWorkReport> pageList(QueryFilter<BizReformWorkReport> queryFilter) {
        queryFilter.addFilter("is_dele_","0", QueryOP.EQUAL);
        if (!ContextUtil.getCurrentUser().isAdmin()) queryFilter.addFilter("CREATE_ORG_ID_", ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        PageList<BizReformWorkReport> model = this.query(queryFilter);
        return model;
    }

    @Override
    public List<WorkReportNumVO> countNum() {
        String createOrgId=ContextUtil.getCurrentOrgId();
        String userId = ContextUtil.getCurrentUserId();

        if (ContextUtil.getCurrentUser().isAdmin()){
            createOrgId=null;
            userId=null;
        }

        return baseMapper.countNum(createOrgId,userId);
    }
}
