package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizReformRiskManagementDao;
import com.artfess.reform.fill.manager.BizReformRiskInvolvedDistrictsManager;
import com.artfess.reform.fill.manager.BizReformRiskManagementManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformRiskInvolvedDistricts;
import com.artfess.reform.fill.model.BizReformRiskManagement;
import com.artfess.reform.fill.vo.StateVO;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;


@Service
public class BizReformRiskManagementManagerImpl extends BaseManagerImpl<BizReformRiskManagementDao, BizReformRiskManagement> implements BizReformRiskManagementManager {

    @Resource
    BizReformRiskInvolvedDistrictsManager bizReformRiskInvolvedDistrictsManager;
    @Resource
    UniversalWayManager universalWayManager;
    @Resource
    SysDictionaryManager sysDictionaryManager;
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    FileManager fileManager;


    @Override
    @Transactional
    public void removeById(String id) {
        Assert.notNull(id, "id不能为空");
        String[] ids = id.split(",");
        for (String res : ids) {
            //审核中和审核通过的无法删除
            bizReformRiskInvolvedDistrictsManager.remove(new QueryWrapper<BizReformRiskInvolvedDistricts>().eq(StringUtil.isNotEmpty(res), "RISK_ID_", res));
            List<Integer> listStatus = new ArrayList<>();
            Collections.addAll(listStatus,0);
            List<BizReformRiskManagement> list = this.list(new QueryWrapper<BizReformRiskManagement>().eq("ID_", res).eq("IS_DELE_", 0).notIn("STATUS_", listStatus));
            if (list.size() > 0) {
                throw new BaseException("已上报的方案无法删除!");
            }
            //删除对应文件
            universalWayManager.deleteFiles(res);
            //删除主数据
            this.removeByIds(res);
        }
    }

    @Override
    @Transactional
    public void updateById(StateVO stateVO) {
        String[] ids = stateVO.getId().split(",");
        for (String res : ids) {
            //修改审核状态
            UpdateWrapper<BizReformRiskManagement> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq("ID_", res).set("STATUS_", stateVO.getStatus());
            //判断是否满足操作日志记录条件
            BizReformRiskManagement entity = super.getOne(new QueryWrapper<BizReformRiskManagement>().eq("ID_", res).eq("IS_DELE_", "0").last("LIMIT 1"));
            boolean check=entity==null||entity.getStatus()!=stateVO.getStatus();
            super.update(updateWrapper);
            if(check)setApprovalLog(stateVO);
        }
    }

    @Override
    @Transactional
    public void insertOrUpdateInfo(BizReformRiskManagement bizReformRiskManagement) {
        if (bizReformRiskManagement != null) {
            bizReformRiskManagement.setCreateOrgId(ContextUtil.getCurrentOrgId());
            if (bizReformRiskManagement.getRiskDate() != null) {
                Map<String, Integer> map = universalWayManager.setDate(bizReformRiskManagement.getRiskDate());
                bizReformRiskManagement.setRiskYear(map.get("year"));
                bizReformRiskManagement.setRiskMonth(map.get("month"));
                bizReformRiskManagement.setRiskQuarter(map.get("quarter"));
            }
            bizReformRiskManagement.setIsDele("0");
            super.saveOrUpdate(bizReformRiskManagement);
            if (bizReformRiskManagement.getBizReformRiskInvolvedDistrictsList().size() > 0) {
                List<BizReformRiskInvolvedDistricts> bizReformRiskInvolvedDistrictsList = bizReformRiskManagement.getBizReformRiskInvolvedDistrictsList();
                //删除之前涉及区县数据
                bizReformRiskInvolvedDistrictsManager.remove(new QueryWrapper<BizReformRiskInvolvedDistricts>().eq(StringUtil.isNotEmpty(bizReformRiskManagement.getId()), "RISK_ID_", bizReformRiskManagement.getId()));
                //添加涉及区县数据
                for (BizReformRiskInvolvedDistricts reformRiskInvolvedDistricts : bizReformRiskInvolvedDistrictsList) {
                    reformRiskInvolvedDistricts.setSignificant(bizReformRiskManagement.getSignificant());
                    reformRiskInvolvedDistricts.setRiskId(bizReformRiskManagement.getId());
                    bizReformRiskInvolvedDistrictsManager.saveOrUpdate(reformRiskInvolvedDistricts);
                }
            }
            //更新附件上传项目id
            if (BeanUtils.isNotEmpty(bizReformRiskManagement.getIds())) {
                universalWayManager.attachmentUpdates(bizReformRiskManagement.getIds(), bizReformRiskManagement.getId());
            }
        }
        
    }

    @Override
    public PageList<BizReformRiskManagement> pageList(QueryFilter<BizReformRiskManagement> queryFilter,boolean isAffirm) {
        queryFilter.addFilter("r.IS_DELE_", "0", QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("r.STATUS_", Direction.ASC));
        sorter.add(new FieldSort("r.LAST_TIME_", Direction.DESC));
        queryFilter.setSorter(sorter);
        if (!ContextUtil.getCurrentUser().isAdmin()&&!isAffirm){
            queryFilter.addFilter("r.CREATE_ORG_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        }
        IPage<BizReformRiskManagement> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public BizReformRiskManagement findById(String id){
        Assert.notNull(id,"id不能为空");
        BizReformRiskManagement model = baseMapper.selectById(id);
        //从操作日志记录表中获取提交驳回意见
        if (BeanUtils.isNotEmpty(model)){
            AchieveStatusLog log = achieveStatusLogManager.getOne(new QueryWrapper<AchieveStatusLog>()
                    .eq("BIZ_ID_", model.getId())
                    .orderByDesc("OPERATE_DATE_")
                    .last("LIMIT 1"));
            if (BeanUtils.isNotEmpty(log)){
                model.setApprovalComments(log.getApprovalComments());
            }
            //查询涉及区县
            QueryWrapper<BizReformRiskInvolvedDistricts> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("RISK_ID_", model.getId());
            model.setBizReformRiskInvolvedDistrictsList(bizReformRiskInvolvedDistrictsManager.list(queryWrapper));
            //查询附件
            List<DefaultFile> fileList = fileManager.list(new QueryWrapper<DefaultFile>().eq("BIZ_ID_", id).eq("IS_DEL_", "0"));
            model.setFileList(fileList);
        }
        return model;
    }

    /**
     * 设置审批日志实体类录入
     */
    private void setApprovalLog(StateVO stateVO){
        // 审批日志
        BizReformRiskManagement model = super.getById(stateVO.getId());
        List<DictModel> fm_shzt = sysDictionaryManager.queryDictListItemsByCode("fm_shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(stateVO.getId());
        logVo.setModeType(1);
        logVo.setBizType("8");
        logVo.setModuleTableName("BIZ_REFORM_RISK_MANAGEMENT");
        if (stateVO.getApprovalResults()!=null&&stateVO.getApprovalResults()==2){
            if(stateVO.getStatus()==0){
                logVo.setItemTitle("【"+model.getRiskName()+"】撤回为草稿");
                logVo.setOperateInfo("撤回为草稿");
            } else if (stateVO.getStatus()==1){
                logVo.setItemTitle("【"+model.getRiskName()+"】撤回为提交待审核");
                logVo.setOperateInfo("撤回为提交待审核");
            }else if (stateVO.getStatus()==3){
                logVo.setItemTitle("【"+model.getRiskName()+"】撤回为审核通过");
                logVo.setOperateInfo("撤回为审核通过");
            }
            logVo.setApprovalResults(2);
        }else {
            if(stateVO.getStatus()==0){
                logVo.setItemTitle("【"+model.getRiskName()+"】风险录入");
            } else if (stateVO.getStatus()==1){
                logVo.setItemTitle("【"+model.getRiskName()+"】提交待审核");
            }else if (stateVO.getStatus()==2){
                logVo.setItemTitle("【"+model.getRiskName()+"】审核驳回");
            }else if (stateVO.getStatus()==3){
                logVo.setItemTitle("【"+model.getRiskName()+"】审核通过");
            }else if (stateVO.getStatus()==4){
                logVo.setItemTitle("【"+model.getRiskName()+"】确认驳回");
            }else if (stateVO.getStatus()==5){
                logVo.setItemTitle("【"+model.getRiskName()+"】确认通过");
            }
            if (stateVO.getStatus()%2==0){
                logVo.setApprovalResults(1);
            }else {
                logVo.setApprovalResults(0);
            }
            logVo.setOperateInfo(BizUtils.getDicValueByCode(fm_shzt, stateVO.getStatus()));
        }

        logVo.setStatus(stateVO.getStatus().toString());

        if (stateVO.getStatus()==2||stateVO.getStatus()==4){
            logVo.setApprovalComments(stateVO.getApprovalComments());
        }else if (stateVO.getStatus()==1){
            logVo.setApprovalComments(null);
        }
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }



}




