package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizPilotAdvanceRecordDao;
import com.artfess.reform.fill.dao.BizReformPilotManagementDao;
import com.artfess.reform.fill.dto.MentDTO;
import com.artfess.reform.fill.manager.*;
import com.artfess.reform.fill.model.*;
import com.artfess.reform.fill.vo.InvVO;
import com.artfess.reform.fill.vo.OperateUserVo;
import com.artfess.reform.fill.vo.StateVO;
import com.artfess.reform.statistics.vo.CountyChartVo;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;


@Service
public class BizReformPilotManagementManagerImpl extends BaseManagerImpl<BizReformPilotManagementDao, BizReformPilotManagement> implements BizReformPilotManagementManager {

    @Resource
    private BizReformInvolvedDistrictsManager bizReformInvolvedDistrictsManager;
    @Resource
    BizPilotAdvanceRecordManager bizPilotAdvanceRecordManager;
    @Resource
    SysDictionaryManager sysDictionaryManager;
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    UniversalWayManager universalWayManager;
    @Resource
    BizPilotAdvanceResultManager bizPilotAdvanceResultManager;
    @Resource
    FileManager fileManager;
    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;
    @Resource
    private BizReformInvolvedDistrictsManager reformInvolvedDistrictsManager;
    @Resource
    BizPilotAdvanceRecordDao bizPilotAdvanceRecordDao;
    @Resource
    BizReformIteratePilotManagementManager bizReformIteratePilotManagementManager;

    @Override
    @Transactional
    public boolean insertInfo(BizReformPilotManagement bizReformPilotManagement) {
        String resDocName = bizReformPilotManagement.getDocName().trim().replaceAll("\\s", "");
        String docNo = resDocName + "【" + bizReformPilotManagement.getDocYear() + "】" + bizReformPilotManagement.getDocNum() + "号";
        if(BeanUtils.isEmpty(bizReformPilotManagement.getUnitId())){
            throw new BaseException("所填主管部门暂未录入成功,请重新尝试添加！");
        }
        bizReformPilotManagement.setStatus(0);
        bizReformPilotManagement.setDocNo(docNo);
        bizReformPilotManagement.setIsDele("0");
        bizReformPilotManagement.setPropulsiveStatus(0);
        boolean res = super.save(bizReformPilotManagement);

        //更新附件的bizId
        if (BeanUtils.isNotEmpty(bizReformPilotManagement.getIds())){
            universalWayManager.attachmentUpdates(bizReformPilotManagement.getIds(), bizReformPilotManagement.getId());
        }

        //更新区县涉及表
        for (BizReformInvolvedDistricts inv : bizReformPilotManagement.getInvs()) {
            inv.setPilotId(bizReformPilotManagement.getId());
            bizReformInvolvedDistrictsManager.save(inv);
        }

        //判断之前填写的涉及区县有填报部门自己，如果没有则新增
        List<String> collect = bizReformPilotManagement.getInvs().stream().map(BizReformInvolvedDistricts::getUnitId).collect(Collectors.toList());
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()&&!collect.contains(ContextUtil.getCurrentOrgId())){
                BizReformInvolvedDistricts bizReform = new BizReformInvolvedDistricts();
                bizReform.setPilotId(bizReformPilotManagement.getId());
                bizReform.setUnitId(ContextUtil.getCurrentOrgId());
                bizReform.setUnitName(ContextUtil.getCurrentOrgName());
                bizReform.setUnitCode(ContextUtil.getCurrentOrgCode());
                bizReform.setUnitGrade(ContextUtil.getCurrentOrgGrade());
                bizReformInvolvedDistrictsManager.create(bizReform);
        }
        //创建时,操作日志记录
        setApprovalLog(bizReformPilotManagement.getId(),null,bizReformPilotManagement.getStatus(),null,0);
        return res;
    }

    @Override
    @Transactional
    public void updateInfo(BizReformPilotManagement bizReformPilotManagement) {
        boolean bothAudit = bothAudit(bizReformPilotManagement.getId(), bizReformPilotManagement.getStatus());
        if (!bothAudit){
            throw new BaseException("该数据已被撤回,无法在进行操作");
        }
        //当修改数据时,修改前数据不为0的时候
        BizReformPilotManagement entity = super.getOne(new QueryWrapper<BizReformPilotManagement>().eq("ID_", bizReformPilotManagement.getId()).eq("IS_DELE_", "0").last("LIMIT 1"));

        List<BizReformInvolvedDistricts> districts = bizReformInvolvedDistrictsManager.list(new QueryWrapper<BizReformInvolvedDistricts>().eq("PILOT_ID_", bizReformPilotManagement.getId()));
        if (bizReformPilotManagement.getInvs().size()>0){
            //判断涉及区县是否新增其他区县
            boolean containsInv = districts.containsAll(bizReformPilotManagement.getInvs());
            //判断是否存在推进数据
            int recordCount = bizPilotAdvanceRecordManager.count(new QueryWrapper<BizPilotAdvanceRecord>().eq("PILOT_ID_", bizReformPilotManagement.getId()).eq("IS_DELE_", "0"));
            if (!containsInv&&recordCount>0){
                //判断当修改时新增区县，推进状态修改为推进中
                bizReformPilotManagement.setPropulsiveStatus(2);
            }
        }

        //判断是否满足条件,满足条件则记录操作日志
       boolean check =entity==null||entity.getStatus()!=bizReformPilotManagement.getStatus();
        if(bizReformPilotManagement.getTimePeriod()==0) bizReformPilotManagement.setAcceptanceTime(null);
       super.update(bizReformPilotManagement);

       if (check)setApprovalLog(bizReformPilotManagement.getId(),null,bizReformPilotManagement.getStatus(),bizReformPilotManagement.getApprovalComments(),0);
        if (BeanUtils.isNotEmpty(bizReformPilotManagement.getInvs())){
            bizReformInvolvedDistrictsManager.remove(new QueryWrapper<BizReformInvolvedDistricts>().eq("PILOT_ID_",bizReformPilotManagement.getId()));
            for (BizReformInvolvedDistricts inv : bizReformPilotManagement.getInvs()) {
                inv.setPilotId(bizReformPilotManagement.getId());
                bizReformInvolvedDistrictsManager.saveOrUpdate(inv);
            }
            List<String> collect = bizReformPilotManagement.getInvs().stream().map(BizReformInvolvedDistricts::getUnitId).collect(Collectors.toList());
            List<BizPilotAdvanceRecord> records = bizPilotAdvanceRecordManager.list(new QueryWrapper<BizPilotAdvanceRecord>().eq("PILOT_ID_", bizReformPilotManagement.getId()).notIn("UNIT_ID_", collect));
            if (null!=records&&records.size()>0){
                List<String> delCollect = records.stream().map(BizPilotAdvanceRecord::getId).collect(Collectors.toList());
                //删除多余试点成果数据
                bizPilotAdvanceResultManager.remove(new QueryWrapper<BizPilotAdvanceResult>().in("RECORD_ID_",delCollect));
                //删除多余区县推进数据
                bizPilotAdvanceRecordManager.remove(new QueryWrapper<BizPilotAdvanceRecord>().in("ID_",delCollect));
            }
        }
        // 判断区县是否满足已完成
        if (bizReformPilotManagement.getInvs().size()>0) {
            verify(bizReformPilotManagement.getId());
        }
        //更新附件的bizId
        if (BeanUtils.isNotEmpty(bizReformPilotManagement.getIds())){
            universalWayManager.attachmentUpdates(bizReformPilotManagement.getIds(), bizReformPilotManagement.getId());
        }

    }

    @Override
    @Transactional
    public void updateByStatus(StateVO stateVO) {
        Assert.notNull(stateVO.getId(),"ID不能为空！");
        Assert.notNull(stateVO.getStatus(),"状态不能为空");
        boolean bothAudit = bothAudit(stateVO.getId(), stateVO.getStatus());
        if (!bothAudit) throw new BaseException("该数据已被撤回,无法在进行操作");
        UpdateWrapper<BizReformPilotManagement> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id_", stateVO.getId()).set("STATUS_", stateVO.getStatus());
        if (stateVO.getStatus()==5){
         updateWrapper.set("PROPULSIVE_STATUS_",1);
        }
        super.update(updateWrapper);
        //录入审批操作日志
        setApprovalLog(stateVO.getId(),stateVO.getApprovalResults(),stateVO.getStatus(),stateVO.getApprovalComments(),0);
    }

    @Override
    @Transactional
    public void removeInfo(String ids) {
        Assert.notNull(ids,"ID不能为空！");
        for (String id : ids.split(",")) {
            List<BizReformPilotManagement> mants = this.list(new QueryWrapper<BizReformPilotManagement>().eq("ID_", id).eq("IS_DELE_", "0"));
            List<Integer> mans = mants.stream().map(BizReformPilotManagement::getStatus).collect(Collectors.toList());
            if (mans.contains(2)||mans.contains(4)||mans.contains(1)||mans.contains(3)||mans.contains(5)){
                throw new BaseException("无法删除除草稿以外的数据！");
            }
            universalWayManager.deleteFiles(id);
            super.remove(id);
        }
    }

    @Override
    public BizPilotAdvanceRecord findModel(String id) {
        BizPilotAdvanceRecord record = bizPilotAdvanceRecordManager.getOne(new QueryWrapper<BizPilotAdvanceRecord>().eq("ID_", id).eq("IS_DELE_", "0"));
        if (record!=null){
            List<BizPilotAdvanceResult> results = bizPilotAdvanceResultManager.list(new QueryWrapper<BizPilotAdvanceResult>().eq("RECORD_ID_", id).eq("IS_DELE_", "0"));
            record.setResults(results);
            results.stream().forEach(p->{
                List<DefaultFile> files = fileManager.list(new QueryWrapper<DefaultFile>()
                        .eq("BIZ_ID_", p.getId())
                        .eq("IS_DEL_","0"));
                p.setFileList(files);
            });
        }
        return record;
    }

    @Override
    public List<BizPilotAdvanceRecord> findByHis(String id,String unitId) {
        List<BizPilotAdvanceRecord> res = bizPilotAdvanceRecordManager.list(
                new QueryWrapper<BizPilotAdvanceRecord>()
                        .eq("PILOT_ID_", id)
                        .eq("IS_DELE_", "0")
                        .eq("UNIT_ID_",unitId)
                        .orderByDesc("CREATE_TIME_")
                        .last("LIMIT 2"));

         res.stream().forEach(p->{
             //获取附件
             List<DefaultFile> recFiles = fileManager.queryFileByBizId(p.getId());
             if (recFiles!=null&&recFiles.size()>0)p.setFileList(recFiles);
             List<BizPilotAdvanceResult> results = bizPilotAdvanceResultManager.list(new QueryWrapper<BizPilotAdvanceResult>().eq("RECORD_ID_", p.getId()).eq("IS_DELE_", "0"));
             results.stream().forEach(t->{
                 List<DefaultFile> files = fileManager.list(new QueryWrapper<DefaultFile>().eq("BIZ_ID_", t.getId()).eq("IS_DEL_", "0"));
                 t.setFileList(files);
             });
             p.setResults(results);

             //从操作日志记录表中获取提交驳回意见
             AchieveStatusLog logCom = achieveStatusLogManager.getOne(new QueryWrapper<AchieveStatusLog>()
                     .eq("BIZ_ID_",p.getId())
                     .in("STATUS_",7,9,11)
                     .orderByDesc("OPERATE_DATE_")
                     .last("LIMIT 1"));
             if (BeanUtils.isNotEmpty(logCom)){
                 p.setApprovalComments(logCom.getApprovalComments());
             }
         });
        return res;
    }

    @Override
    public boolean ifExists(String docNo) {
        Assert.notNull(docNo,"需匹配的文号不能为空!!!");
        List<BizReformPilotManagement> res = super.list(new QueryWrapper<BizReformPilotManagement>().eq("DOC_NO_", docNo).eq("IS_DELE_", "0"));
        return null == res || res.size() <= 0;
    }

    @Override
    public PageList<BizReformPilotManagement> queryInput(MentDTO dto) {
        if (dto.getPage()==null)dto.setPage(1);
        if (dto.getSize()==null)dto.setSize(20);
        if (dto.getIsDele()==null)dto.setIsDele("0");
        IUser user = ContextUtil.getCurrentUser();
        if (user!=null&&user.isAdmin()){
            dto.setCreateOrgId(null);
            dto.setUnitId(null);
        }
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage());
        pageBean.setPageSize(dto.getSize());
        IPage<BizReformPilotManagement> page = baseMapper.queryInput(convert2IPage(pageBean),dto.getProjectName(),dto.getDocNo(),dto.getPilotLevel(), dto.getPilotField(), dto.getPilotRunway(), dto.getIsDele(), dto.getStatus(),dto.getStatusList(), dto.getCreateOrgId(), dto.getUnitId());
        return new PageList<>(page);
    }

    @Override
    public PageList<BizReformPilotManagement> disQueryList(QueryFilter<BizReformPilotManagement> filter) {
        filter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        filter.addFilter("STATUS_", 0, QueryOP.NOT_EQUAL);
        IUser user = ContextUtil.getCurrentUser();
        if (user !=null&&!user.isAdmin())filter.addFilter("CREATE_ORG_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        IPage<BizReformPilotManagement> iPage = baseMapper.pushQuery(convert2IPage(filter.getPageBean()), convert2Wrapper(filter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizReformPilotManagement> pilQueryList(QueryFilter<BizReformPilotManagement> filter) {
        filter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        filter.addFilter("STATUS_",2, QueryOP.GREAT);
        IUser user = ContextUtil.getCurrentUser();
        if (user !=null&&!user.isAdmin()) filter.addFilter("UNIT_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        IPage<BizReformPilotManagement> iPage = baseMapper.pushQuery(convert2IPage(filter.getPageBean()),convert2Wrapper(filter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public BizReformPilotManagement findById(String id) {
        Assert.notNull(id,"ID不能为空");
        //从操作日志查询涉及区县列表
        BizReformPilotManagement pilot = baseMapper.selectById(id);
        if (pilot!=null){
            List<BizReformInvolvedDistricts> inv = bizReformInvolvedDistrictsManager.list(new QueryWrapper<BizReformInvolvedDistricts>().eq("PILOT_ID_", pilot.getId()));
            if (inv!=null&&inv.size()>0)pilot.setInvs(inv);
            //从操作日志记录表中获取提交驳回意见
            AchieveStatusLog log = achieveStatusLogManager.getOne(new QueryWrapper<AchieveStatusLog>()
                    .eq("BIZ_ID_", pilot.getId())
                    .orderByDesc("OPERATE_DATE_")
                    .last("LIMIT 1"));
            if (BeanUtils.isNotEmpty(log)&&(pilot.getStatus()==0||pilot.getStatus()==2||pilot.getStatus()==4))pilot.setApprovalComments(log.getApprovalComments());
            //查询迭代表中与该试点相关联的最新数据
            BizReformIteratePilotManagement iteratePilotManagement = bizReformIteratePilotManagementManager.getOne(new QueryWrapper<BizReformIteratePilotManagement>()
                    .eq("PILOT_ID_", id)
                    .orderByDesc("CREATE_TIME_")
                    .last("LIMIT 1"));
            if (iteratePilotManagement!=null){
                pilot.setIterStatus(iteratePilotManagement.getStatus());
                pilot.setIterId(iteratePilotManagement.getId());
            }
        }
        return pilot;
    }

    @Override
    public PageList<InvVO> invPush(MentDTO dto,boolean isAffirm) {
        if (BeanUtils.isEmpty(dto.getPage()))dto.setPage(1);
        if (BeanUtils.isEmpty(dto.getSize()))dto.setSize(20);
        if (BeanUtils.isEmpty(dto.getIsDele()))dto.setIsDele("0");
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage());
        pageBean.setPageSize(dto.getSize());
        if (!ContextUtil.getCurrentUser().isAdmin()&&ContextUtil.getCurrentUser() !=null&&!isAffirm) {
            dto.setUnitId(ContextUtil.getCurrentOrgId());
        }
        IPage<InvVO> iPage = baseMapper.invPush(convert2IPage(pageBean), dto.getUnitId(),dto.getUnitName(),dto.getMainUnitName(), dto.getDocNo(), dto.getProjectName(), dto.getPilotLevel(), dto.getStatus(), dto.getPilotField(), dto.getPilotRunway(), dto.getPilotSupervisor(),dto.getPropulsiveStatus(),dto.getIsDele());
        return new PageList<>(iPage);
    }

    @Override
    public PageList<InvVO> invAudit(MentDTO dto) {
        if (BeanUtils.isEmpty(dto.getPage()))dto.setPage(1);
        if (BeanUtils.isEmpty(dto.getSize()))dto.setSize(20);
        if (BeanUtils.isEmpty(dto.getIsDele()))dto.setIsDele("0");
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage());
        pageBean.setPageSize(dto.getSize());
        if (!ContextUtil.getCurrentUser().isAdmin()&&ContextUtil.getCurrentUser() !=null) {
            dto.setUnitId(ContextUtil.getCurrentOrgId());
        }
        IPage<InvVO> iPage = baseMapper.invAudit(convert2IPage(pageBean), dto.getUnitId(),dto.getUnitName(),dto.getMainUnitName(), dto.getDocNo(), dto.getProjectName(), dto.getPilotLevel(), dto.getPilotSupervisor(),dto.getStatusList(), dto.getStatus(), dto.getPilotField(), dto.getPilotRunway(), dto.getPropulsiveStatus(),dto.getIsDele());
        return new PageList<>(iPage);
    }

    @Override
    public PageList<InvVO> pilAudit(MentDTO dto) {
        if (BeanUtils.isEmpty(dto.getPage()))dto.setPage(1);
        if (BeanUtils.isEmpty(dto.getSize()))dto.setSize(20);
        if (BeanUtils.isEmpty(dto.getIsDele()))dto.setIsDele("0");
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage());
        pageBean.setPageSize(dto.getSize());
        if (!ContextUtil.getCurrentUser().isAdmin()&&ContextUtil.getCurrentUser()!=null) {
            dto.setUnitId(ContextUtil.getCurrentOrgId());
        }
        IPage<InvVO> iPage = baseMapper.pilAudit(convert2IPage(pageBean), dto.getUnitId(),dto.getUnitName(),dto.getMainUnitName(), dto.getDocNo(),dto.getProjectName(), dto.getPilotLevel(), dto.getPilotSupervisor(), dto.getStatusList(), dto.getStatus(), dto.getPilotField(), dto.getPilotRunway(), dto.getPropulsiveStatus(),dto.getIsDele());
        return new PageList<>(iPage);
    }

    @Override
    public PageList<InvVO> munAudit(MentDTO dto)  {
        if (BeanUtils.isEmpty(dto.getPage()))dto.setPage(1);
        if (BeanUtils.isEmpty(dto.getSize()))dto.setSize(20);
        if (BeanUtils.isEmpty(dto.getIsDele()))dto.setIsDele("0");
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage());
        pageBean.setPageSize(dto.getSize());
        IPage<InvVO> iPage = baseMapper.munAudit(convert2IPage(pageBean),null,dto.getUnitName(),dto.getMainUnitName(), dto.getDocNo(), dto.getProjectName(), dto.getPilotLevel(), dto.getPilotSupervisor(), dto.getStatusList(), dto.getStatus(), dto.getPilotField(), dto.getPilotRunway(), dto.getPropulsiveStatus(),dto.getIsDele());
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizReformPilotManagement> queryGroup(QueryFilter<BizReformPilotManagement> queryFilter, String code) {
        queryFilter.addFilter("m.is_dele_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("m.status_",5,QueryOP.EQUAL);
        IPage<BizReformPilotManagement> iPage = baseMapper.queryGroup(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()), code);
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizReformPilotManagement> munInfo(QueryFilter<BizReformPilotManagement> queryFilter) {
        queryFilter.addFilter("m.IS_DELE_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("m.STATUS_",5,QueryOP.EQUAL);
        IPage<BizReformPilotManagement> iPage = baseMapper.munInfo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public void  pilotExport(HttpServletResponse response, MentDTO dto ) throws Exception {
        List<Map<String, Object>> list = new ArrayList<>();
        PageBean pageBean = new PageBean();
        pageBean.setPage(dto.getPage());
        pageBean.setPageSize(dto.getSize());
        dto.setUnitId(null);
        List<InvVO> records = baseMapper.excelInfo(convert2IPage(pageBean), dto.getUnitId(),dto.getUnitName(),dto.getMainUnitName(), dto.getDocNo(), dto.getProjectName(), dto.getPilotLevel(), dto.getPilotSupervisor(), dto.getStatusList(), dto.getStatus(),dto.getPilotField(),dto.getPilotRunway(),dto.getPropulsiveStatus()).getRecords();
        PageList<InvVO> models = new PageList<>(records);
        if (BeanUtils.isNotEmpty(models.getRows())) {
            models.getRows().stream().forEach(p -> {
                try {
                    String jsonStr = JsonUtil.toJson(p);
                    Map<String, Object> map = JsonUtil.toMap(jsonStr);
                    //审核状态
                    if (map.get("recordsStatus") != null) {
                        String recordsStatus = map.get("recordsStatus").toString();
                        String recordsStatusText = sysDictionaryDetailManager.getTextByValue("ggsd_shzt", recordsStatus);
                        map.put("recordsStatusText", recordsStatusText);
                    } else {
                        map.put("recordsStatusText", "");
                    }
                    //试点层级
                    if (map.get("pilotLevel") != null) {
                        String pilotLevel = map.get("pilotLevel").toString();
                        String pilotLevelText = sysDictionaryDetailManager.getTextByValue("ggb_sdcj", pilotLevel);
                        map.put("pilotLevelText", pilotLevelText);
                    } else {
                        map.put("pilotLevelText", "");
                    }
                    list.add(map);
                } catch (Exception e) {
                    throw new RuntimeException("导出失败：" + e.getMessage());
                }
                });
                    String tempName = "改革试点项目";
                    Map<String, String> exportMaps = new LinkedHashMap<>();
                    exportMaps.put("pilotProjectName", "试点项目名称");
                    exportMaps.put("docNo", "试点项目文号");
                    exportMaps.put("pilotLevelText", "试点层级");
                    exportMaps.put("mainUnitName", "市级主管部门");
                    exportMaps.put("unitName", "上报区县");
                    exportMaps.put("auditTime", "提交审核时间");
                    exportMaps.put("recordsStatusText", "审核状态");
                    exportMaps.put("propulsiveDetails", "已开展工作");
                    exportMaps.put("existingProblems", "存在问题");
                    exportMaps.put("workPlan", "下一步工作计划");
                    HSSFWorkbook book = ExcelUtil.exportExcel(tempName, 24, exportMaps, list);
                    ExcelUtil.downloadExcel(book, tempName, response);
        }
    }

    @Override
    @Transactional
    public void auditRemoveInfo(String ids,boolean isAffirm) {
        Assert.notNull(ids,"需要删除的id不能为空");
        String[] res = ids.split(",");
        for (String id : res) {
            if (BeanUtils.isNotEmpty(isAffirm)&&!isAffirm){
                int count = bizPilotAdvanceRecordManager.count(new QueryWrapper<BizPilotAdvanceRecord>().eq("PILOT_ID_", id).eq("STATUS_", "12").eq("is_dele_", "0"));
                if (count>0) throw new BaseException("该试点项目推进信息,已存在改革办审核通过的数据,无法删除!!!");
            }
            //删除存在的附件
            universalWayManager.deleteFiles(id);
            //删除试点成果信息
            bizPilotAdvanceResultManager.remove(new QueryWrapper<BizPilotAdvanceResult>().eq("PILOT_ID_",id).eq("IS_DELE_","0"));
            //删除推进信息
            bizPilotAdvanceRecordManager.remove(new QueryWrapper<BizPilotAdvanceRecord>().eq("PILOT_ID_",id).eq("IS_DELE_","0"));
            //删除涉及区县
            bizReformInvolvedDistrictsManager.remove(new QueryWrapper<BizReformInvolvedDistricts>().eq("PILOT_ID_",id));
            //记录操作日志
            setApprovalLog(id,null,-1,null,1);
            super.removeById(id);
        }
    }
    /**
     * 审批日志
     * @param
     */
    @Transactional
    public void setApprovalLog(String bizId,Integer approvalResults,Integer status,String approvalComments,Integer type) {
        BizReformPilotManagement model = this.getById(bizId);
        List<DictModel> glb_shzt = sysDictionaryManager.queryDictListItemsByCode("glb_shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(bizId);
        logVo.setModeType(1);
        logVo.setModuleTableName("BIZ_REFORM_PILOT_MANAGEMENT");
        if (type==0){
            if (BeanUtils.isEmpty(approvalResults)){
                if (status == 0) {
                    logVo.setItemTitle("【" + model.getPilotProjectName() + "】试点项目录入");
                } else if (status == 1) {
                    logVo.setItemTitle("【" + model.getPilotProjectName() + "】提交本级审核");
                } else if (status == 2) {
                    logVo.setItemTitle("【" + model.getPilotProjectName() + "】本级审核驳回");
                } else if (status == 3) {
                    logVo.setItemTitle("【" + model.getPilotProjectName() + "】提交部门确认");
                } else if (status == 4) {
                    logVo.setItemTitle("【" + model.getPilotProjectName() + "】部门确认驳回");
                } else if (status == 5) {
                    logVo.setItemTitle("【" + model.getPilotProjectName() + "】部门确认分发");
                }
                logVo.setOperateInfo(BizUtils.getDicValueByCode(glb_shzt,status));
                logVo.setApprovalResults(status % 2 == 0&&status!=0?1:0);
            }else if (approvalResults==2){
                if (status==0){
                    logVo.setItemTitle("【"+model.getPilotProjectName()+"】撤回为草稿");
                    logVo.setOperateInfo("撤回为草稿");
                }else if (status==1){
                    logVo.setItemTitle("【"+model.getPilotProjectName()+"】撤回为提交本级审核");
                    logVo.setOperateInfo("撤回为提交本级审核");
                }else if (status==3){
                    logVo.setItemTitle("【"+model.getPilotProjectName()+"】撤回为提交部门确认");
                    logVo.setOperateInfo("撤回为提交部门确认");
                }
                logVo.setApprovalResults(2);
            }
        }else {
            logVo.setItemTitle("【"+model.getPilotProjectName()+"】删除该试点");
            logVo.setOperateInfo("删除该试点");
        }

        logVo.setStatus(status.toString());
        logVo.setApprovalComments(approvalComments);
        logVo.setBizType("5");
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        if (BeanUtils.isNotEmpty(logVo))achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);

    }

    @Override
    public List<CountyChartVo> lineChartDataForLargeScreen(Integer year,Integer quarter) {
        return baseMapper.lineChartDataForLargeScreen(year,quarter);
    }

    @Override
    public boolean inputRevInfo(String pid) {
        List<BizPilotAdvanceRecord> list = bizPilotAdvanceRecordManager.list(new QueryWrapper<BizPilotAdvanceRecord>()
                .eq("PILOT_ID_", pid)
                .eq("IS_DELE_", "0"));
        return list.isEmpty();
    }

    @Override
    public void distinct() {
        List<BizReformPilotManagement> list = this.list();
        for (BizReformPilotManagement bizReformPilotManagement : list) {
            List<AchieveStatusLog> bizId = achieveStatusLogManager.list(new QueryWrapper<AchieveStatusLog>().eq("BIZ_ID_", bizReformPilotManagement.getId()).orderByAsc("SN_"));
            for (int i = 0; i < bizId.size(); i++) {
                AchieveStatusLog achieveStatusLog = bizId.get(i);
                if (i!=bizId.size()-1){
                    AchieveStatusLog achieveStatusLog1 = bizId.get(i + 1);
                    if (achieveStatusLog.getStatus().equals(achieveStatusLog1.getStatus())){
                        achieveStatusLogManager.remove(new QueryWrapper<AchieveStatusLog>().eq("ID_",achieveStatusLog1.getId()));
                    }
                }
            }
            }

        }

    @Override
    public List<BizReformPilotManagement> pilotLedger(Integer year, Integer quarter) {
        return baseMapper.pilotLedger(year,quarter);
    }

    @Override
    @Transactional
    public boolean updateIterateInfo(BizReformPilotManagement bizReformPilotManagement) {
        Assert.notNull(bizReformPilotManagement.getId(),"需修改的项目id不能为空");
        String id = bizReformPilotManagement.getId();
        //判断验收时间
        BizReformPilotManagement entity = super.getById(id);
        if (entity!=null&&(!bizReformPilotManagement.getIterTimePeriod().equals(entity.getTimePeriod())||!bizReformPilotManagement.getIterAcceptanceTime().equals(entity.getAcceptanceTime()))){
            BizReformIteratePilotManagement iterEntity=new BizReformIteratePilotManagement();
            //更新迭代表
            iterEntity.setPilotId(id);
            iterEntity.setIterateType(0);
            iterEntity.setPilotType(0);
            iterEntity.setStatus(bizReformPilotManagement.getStatus());
            iterEntity.setId(null);
            iterEntity.setClassified(bizReformPilotManagement.getIterClassified());
            iterEntity.setIterateCause(bizReformPilotManagement.getCause());
            iterEntity.setTimePeriod(bizReformPilotManagement.getTimePeriod());
            iterEntity.setAcceptanceTime(bizReformPilotManagement.getAcceptanceTime());
            iterEntity.setIterTimePeriod(bizReformPilotManagement.getIterTimePeriod());
            iterEntity.setIterAcceptanceTime(bizReformPilotManagement.getIterAcceptanceTime());
            iterEntity.setPilotProjectName(bizReformPilotManagement.getPilotProjectName());
            boolean res = bizReformIteratePilotManagementManager.saveOrUpdate(iterEntity);
            bizReformIteratePilotManagementManager.setApprovalLog(iterEntity,null);
            List<String> fileIds = bizReformPilotManagement.getIterFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
            if (fileIds!=null&&fileIds.size()>0)universalWayManager.attachmentUpdates(fileIds,iterEntity.getId());
            return res;
        }
        return true;
    }


    @Override
    public BizReformPilotManagement queryDeleteById(String id) {
        Assert.notNull(id,"id不能为空");
        BizReformPilotManagement entity = baseMapper.findDeleteId(id);
        return entity;
    }

    @Override
    public OperateUserVo operateDeleteById(String id) {
        Assert.notNull(id,"id不能为空");
        OperateUserVo userVo = baseMapper.operateUserById(id);
        return userVo;
    }

    /**
     *撤回时，两边修改操作判断
     */
    boolean  bothAudit(String id,Integer status){
        BizReformPilotManagement entity = super.getById(id);
        switch (status){
            case 0:
                return entity.getStatus() == 2 || entity.getStatus() == 4 || entity.getStatus() == null || entity.getStatus() == 1 || entity.getStatus() == 0;
            case 1:
                return entity.getStatus() == 0 || entity.getStatus() == 2 || entity.getStatus() == 3 || entity.getStatus() == 1;
            case 2:
                return entity.getStatus() == 1 || entity.getStatus() == 2;
            case 3:
                return entity.getStatus() == 1 || entity.getStatus() == 3 || entity.getStatus() == 4 || entity.getStatus() == 5;
            case 4:
                return entity.getStatus() == 3 || entity.getStatus() == 4;
            case 5:
                return entity.getStatus() == 3 || entity.getStatus() == 5;
            default:
                return false;
        }
    }

    @Override
    public PageList<BizReformPilotManagement> queryDetail(QueryFilter<BizReformPilotManagement> queryFilter) {
        queryFilter.addFilter("m.is_dele_","0",QueryOP.EQUAL);
        queryFilter.addFilter("m.status_",5,QueryOP.EQUAL);
        queryFilter.addFilter("r.status_",12,QueryOP.EQUAL);
        queryFilter.addFilter("rec.overNum","null",QueryOP.IS_NULL);
        IPage<BizReformPilotManagement> iPage  =baseMapper.queryDetail(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        PageList<BizReformPilotManagement> entity = new PageList<>(iPage);
        if(entity.getRows()!=null && entity.getRows().size()>0){
            List<String> list = new ArrayList<>();
            for(BizReformPilotManagement reformPilotManagement:entity.getRows()){
                list.add(reformPilotManagement.getId());
            }
            List<BizReformInvolvedDistricts> districts = reformInvolvedDistrictsManager.list(new QueryWrapper<BizReformInvolvedDistricts>().in("PILOT_ID_",list));
            if(districts!=null && districts.size()>0){
                entity.getRows().forEach(d->{
                    List<BizReformInvolvedDistricts> invs = districts.stream().filter(dt -> d.getId().equals(dt.getPilotId())).collect(Collectors.toList());
                    d.setInvs(invs);
                });
            }

        }
        return entity;
    }

    @Override
    public PageList<BizReformPilotManagement> queryDetailSpc(QueryFilter<BizReformPilotManagement> queryFilter) {
        queryFilter.addFilter("m.is_dele_","0",QueryOP.EQUAL);;
        queryFilter.addFilter("m.status_",5,QueryOP.EQUAL);
        queryFilter.addFilter("rec.overNum","null",QueryOP.IS_NULL);
        IPage<BizReformPilotManagement> iPage  =baseMapper.queryDetailSpc(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        PageList<BizReformPilotManagement> entity = new PageList<>(iPage);
        if(entity.getRows()!=null && entity.getRows().size()>0){
            List<String> list = new ArrayList<>();
            for(BizReformPilotManagement reformPilotManagement:entity.getRows()){
                list.add(reformPilotManagement.getId());
            }
            List<BizReformInvolvedDistricts> districts = reformInvolvedDistrictsManager.list(new QueryWrapper<BizReformInvolvedDistricts>().in("PILOT_ID_",list));
            if(districts!=null && districts.size()>0){
                entity.getRows().forEach(d->{
                    List<BizReformInvolvedDistricts> invs = districts.stream().filter(dt -> d.getId().equals(dt.getPilotId())).collect(Collectors.toList());
                    d.setInvs(invs);
                });
            }

        }
        return entity;
    }

    @Override
    public List<BizReformPilotManagement> queryLatestDetail(QueryFilter<BizReformPilotManagement> queryFilter) {
        return  this.baseMapper.queryLatestRecordsForInvolved(convert2Wrapper(queryFilter, currentModelClass()));
    }

    @Override
    public List<BizReformPilotManagement> queryLatest(QueryFilter<BizReformPilotManagement> queryFilter) {
        return this.baseMapper.queryLatestRecords(convert2Wrapper(queryFilter, currentModelClass()));
    }

    @Override
    public PageList<BizReformPilotManagement> queryDetailForUnit(QueryFilter<BizReformPilotManagement> queryFilter) {
        queryFilter.addFilter("rec.status_",12,QueryOP.EQUAL);
        IPage<BizReformPilotManagement> iPage  =this.baseMapper.queryDetailForUnit(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        PageList<BizReformPilotManagement> data = new PageList<>(iPage);
        if(data.getRows()!=null && data.getRows().size()>0){
            List<String> list = new ArrayList<>();
            for(BizReformPilotManagement reformPilotManagement:data.getRows()){
                list.add(reformPilotManagement.getId());
            }
            List<BizReformInvolvedDistricts> districts = reformInvolvedDistrictsManager.list(new QueryWrapper<BizReformInvolvedDistricts>().in("PILOT_ID_",list));
            if(districts!=null && districts.size()>0){
                data.getRows().forEach(d->{
                    List<BizReformInvolvedDistricts> invs = districts.stream().filter(dt -> d.getId().equals(dt.getPilotId())).collect(Collectors.toList());
                    d.setInvs(invs);
                });
            }

        }
        return data;
    }

    /**
     * 验证填报区县是否全部验收,全部验收则更新推进状态
     * @param id
     * @return
     */
    @Transactional
    public void verify(String id){
        //查询试点项目涉及区县数量
        int invCount = bizReformInvolvedDistrictsManager.count(new QueryWrapper<BizReformInvolvedDistricts>().eq("pilot_id_", id));
        //查询试点项目已审核完成,且推进状态已验收的区县数量
        int recCount = bizPilotAdvanceRecordDao.recCount(id);
        //当推进状态已验收,且改革办审核通过时,修改主表推进状态为已验收
        if (BeanUtils.isNotEmpty(recCount)&&BeanUtils.isNotEmpty(invCount)&&invCount<=recCount){
                //更新推进状态
                UpdateWrapper<BizReformPilotManagement> updateWrapper = new UpdateWrapper<>();
                updateWrapper.eq("id_",id);
                updateWrapper.set("PROPULSIVE_STATUS_",3);
                super.update(updateWrapper);
        }
    }

}
