package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.fill.dao.BizReformDemandAssignmentDao;
import com.artfess.reform.fill.manager.BizProjectCooperativeUnitManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentRecordManager;
import com.artfess.reform.fill.model.BizProjectCooperativeUnit;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;
import com.artfess.reform.fill.vo.DemandAssignmentVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 改革需求分析-需求交办表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
@Service
public class BizReformDemandAssignmentManagerImpl extends BaseManagerImpl<BizReformDemandAssignmentDao, BizReformDemandAssignment> implements BizReformDemandAssignmentManager {

    @Resource
    private BizReformDemandAssignmentRecordManager bizReformDemandAssignmentRecordManager;

    @Resource
    private BizProjectCooperativeUnitManager bizProjectCooperativeUnitManager;

    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Resource
    private FileManager fileManager;

    @Override
    public PageList<BizReformDemandAssignment> queryPageList(QueryFilter<BizReformDemandAssignment> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizReformDemandAssignment> result=baseMapper.queryPageList(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);

    }

    @Override
    @Transactional
    public String insertAssignment(BizReformDemandAssignment assignment) {
        String orgGrand = assignment.getResponsibleUnitGrade();
        if(orgGrand.equals("1")){
            //主要责任单位类型（1：市级部门，2：区县)
            assignment.setResponsibleUnitType("1");
        }else {
            assignment.setResponsibleUnitType("2");
        }
        assignment.setPropulsiveYear(assignment.getMeetingDate().getYear());
        assignment.setPropulsiveMonth(assignment.getMeetingDate().getMonthValue());
        assignment.setPropulsiveQuarter(Integer.valueOf(assignment.getMeetingDate().getMonthValue() + 2) / 3);
        this.baseMapper.insert(assignment);
        List<BizProjectCooperativeUnit> coordination = assignment.getCoordination();
        if (BeanUtils.isNotEmpty(coordination)) {
            coordination.stream().forEach(p -> {
                p.setProjectId(assignment.getId());
                p.setMaiinType(2);
                bizProjectCooperativeUnitManager.create(p);
            });
        }
        return assignment.getId();
    }

    @Override
    public List<BizReformDemandAssignmentRecord> records(String projectId) {
        QueryWrapper<BizReformDemandAssignmentRecord> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PROJECT_ID_",projectId);
        return bizReformDemandAssignmentRecordManager.list(queryWrapper);
    }

    @Override
    public PageList<BizReformDemandAssignment> queryAudit(QueryFilter<BizReformDemandAssignment> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizReformDemandAssignment> result=baseMapper.queryAudit(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);

    }

    @Override
    public PageList<DemandAssignmentVo> queryDemandAssignment(QueryFilter<BizReformDemandAssignment> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DemandAssignmentVo> result=baseMapper.queryDemandAssignment(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);

    }


    @Override
    public BizReformDemandAssignment queryById(String id) {
        Assert.hasText(id, "ID不能为空！");
        BizReformDemandAssignment  assignment = this.baseMapper.selectById(id);
        if(assignment!=null){
            QueryWrapper<BizReformDemandAssignmentRecord> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("PROJECT_ID_",id);
            queryWrapper.orderByDesc("CREATE_TIME_");
            queryWrapper .last("LIMIT 2");
            List<BizReformDemandAssignmentRecord> records = bizReformDemandAssignmentRecordManager.list(queryWrapper);
            for (BizReformDemandAssignmentRecord record : records){
                Integer status = record.getStatus();
                record.setIsHis(status == 5);
                if(status==2 || status==4){
                    AchieveStatusLog log = achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(record.getId(),status);
                    record.setApprovalComments(log.getApprovalComments());
                }
                QueryWrapper<DefaultFile> fileQuery = new QueryWrapper<>();
                fileQuery.eq("biz_id_",record.getId());
                record.setFiles(fileManager.list(fileQuery));
            }
            assignment.setRecords(records);
        }
        return assignment;
    }

    @Override
    public boolean updateDemandStatus(String id, Integer demandStatus) {
        Assert.hasText(id, "id不能为空！");
        Assert.notNull(demandStatus, "推进状态不能为空！");
        UpdateWrapper<BizReformDemandAssignment> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id_", id).set("DEMAND_STATUS_", demandStatus);
        int num = this.baseMapper.update(null,updateWrapper);
        return num>0;
    }


}
