package com.artfess.reform.fill.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.dao.BizPilotAdvanceResultDao;
import com.artfess.reform.fill.manager.BizPilotAdvanceResultManager;
import com.artfess.reform.fill.model.BizPilotAdvanceResult;
import com.artfess.reform.statistics.vo.CountyPilotReformVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class BizPilotAdvanceResultManagerImpl extends BaseManagerImpl<BizPilotAdvanceResultDao, BizPilotAdvanceResult> implements BizPilotAdvanceResultManager {

    @Resource
    private FileManager fileManager;


    @Override
    public List<CountyPilotReformVo> count(int type, Integer year,Integer quarter,String unitCode) {
        // 获取当前年,季度
        if(year == null || year ==0){
            year = LocalDate.now().getYear();
        }
        if(quarter == null || quarter ==0){
            quarter=LocalDate.now().get(IsoFields.QUARTER_OF_YEAR);
        }
        List<CountyPilotReformVo> data = baseMapper.count(type,year, quarter,unitCode);
   /*     switch (type) {
            case 0: //全年所有的数据
                data = baseMapper.count(type,year, null,unitCode);
                break;
            case 1: //全年截止季度的所有的数据
                data = baseMapper.count(year, quarter,unitCode);
                break;
            case -1://全年截止季度的所有的数据
                data = quarter == 1 ? data : baseMapper.count(year, quarter - 1,unitCode);
                break;
            default:
                throw new RuntimeException("类型传递异常【类型：0 所有总数、1 当前季度总数、-1 上一季度总数】");
        }*/
        return data;
    }

    /**
     * 重写以关联附件
     */
    @Override
    public PageList<BizPilotAdvanceResult> pilotResultDetail(QueryFilter<BizPilotAdvanceResult> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Map<String, Object>  queryMap =  queryFilter.getParams();
        if (queryMap.isEmpty()) {
            queryMap.put("year",LocalDate.now().getYear());
            queryMap.put("quarter",LocalDate.now().get(IsoFields.QUARTER_OF_YEAR));
            queryFilter.setParams(queryMap);
        }
        queryFilter.addFilter("p.is_dele_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("p.STATUS_", 5, QueryOP.EQUAL);
        queryFilter.addFilter("a.status_",12,QueryOP.EQUAL);
        queryFilter.addFilter("r.is_dele_","0",QueryOP.EQUAL);
        IPage<BizPilotAdvanceResult> result = baseMapper.queryResult(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        PageList<BizPilotAdvanceResult> data = new PageList<>(result);
        if(data.getRows()!=null&&data.getRows().size()>0){
            fillFiles(data.getRows());
        }
        return data;
    }

    @Override
    public List<BizPilotAdvanceResult> queryDeleteById(String recId) {
        List<BizPilotAdvanceResult> list = baseMapper.findDeleteId(recId);
        list.stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            if (files!=null&&files.size()>0){
                p.setFileList(files);
            }
        });
        return list;
    }

    @Override
    public List<BizPilotAdvanceResult> list(Wrapper<BizPilotAdvanceResult> queryWrapper) {
        return fillFiles(super.list(queryWrapper));
    }
    @Override
    public List<BizPilotAdvanceResult> list() {
        return fillFiles(super.list());
    }

    private List<BizPilotAdvanceResult> fillFiles(List<BizPilotAdvanceResult> data){
        if(data!=null && data.size()>0){
            List<String> bizIds = new ArrayList<>();
            for(BizPilotAdvanceResult result:data){
                bizIds.add(result.getId());
            }
            QueryWrapper<DefaultFile> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("BIZ_CODE_", "PilotResult").in("BIZ_ID_",bizIds);
            List<DefaultFile> files = fileManager.list(queryWrapper);
            if(files!=null && files.size()>0){
                data.forEach(d->d.setFileList(files.stream().filter(f -> f.getBizId().equals(d.getId())).collect(Collectors.toList())));
            }
        }
        return data;
    }

}
