package com.artfess.reform.fill.manager.impl;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizPilotAdvanceRecordDao;
import com.artfess.reform.fill.manager.*;
import com.artfess.reform.fill.model.BizPilotAdvanceRecord;
import com.artfess.reform.fill.model.BizPilotAdvanceResult;
import com.artfess.reform.fill.model.BizReformInvolvedDistricts;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.vo.OperateUserVo;
import com.artfess.reform.fill.vo.StateVO;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;


@Service
public class BizPilotAdvanceRecordManagerImpl extends BaseManagerImpl<BizPilotAdvanceRecordDao,BizPilotAdvanceRecord> implements BizPilotAdvanceRecordManager {
@Resource
BizReformPilotManagementManager bizReformPilotManagementManager;
@Resource
BizPilotAdvanceResultManager bizPilotAdvanceResultManager;
@Resource
SysDictionaryManager sysDictionaryManager;
@Resource
AchieveStatusLogManager achieveStatusLogManager;
@Resource
UniversalWayManager universalWayManager;
@Resource
BizReformInvolvedDistrictsManager bizReformInvolvedDistrictsManager;
@Resource
FileManager fileManager;


    @Override
    @Transactional
    public void updateById(StateVO stateVO) {
        Assert.notNull(stateVO.getId(),"id不能为空");
        Assert.notNull(stateVO.getStatus(),"状态不能为空");
        UpdateWrapper<BizPilotAdvanceRecord> updateWrapper=new UpdateWrapper<>();
        updateWrapper.eq("ID_",stateVO.getId()).set("STATUS_",stateVO.getStatus()).eq("IS_DELE_","0");
        super.update(updateWrapper);
        //判断当执行撤回操作时，将主表推进状态置为推进中
        if (stateVO.getApprovalResults()!=null&&stateVO.getApprovalResults()==2){
            BizPilotAdvanceRecord entity = super.getOne(new QueryWrapper<BizPilotAdvanceRecord>().eq("ID_", stateVO.getId()), false);
            bizReformPilotManagementManager.update(new UpdateWrapper<BizReformPilotManagement>().eq("ID_",entity.getPilotId()).set("PROPULSIVE_STATUS_",2));
        }
        //审批日志的录入
        setApprovalLog(stateVO.getId(),stateVO.getApprovalResults(),stateVO.getStatus(),stateVO.getApprovalComments());
    }

    @Override
    @Transactional
    public void batchUpdateById(StateVO stateVO) {
        Assert.notNull(stateVO.getIds(),"id集合不能为空");
        Assert.notNull(stateVO.getStatus(),"状态不能为空");
        List<String> ids = stateVO.getIds();
        ids.stream().forEach(p->{
            UpdateWrapper<BizPilotAdvanceRecord> updateWrapper=new UpdateWrapper<>();
            updateWrapper.eq("ID_",p).set("STATUS_",stateVO.getStatus()).eq("IS_DELE_","0");
            super.update(updateWrapper);
            //审批日志的录入
            setApprovalLog(p,stateVO.getApprovalResults(),stateVO.getStatus(),stateVO.getApprovalComments());
        });

    }

    @Override
    @Transactional
    public String saveQuery(BizPilotAdvanceRecord bizPilotAdvanceRecord) {
        bizPilotAdvanceRecord.setUnitId(ContextUtil.getCurrentOrgId());
        bizPilotAdvanceRecord.setUnitName(ContextUtil.getCurrentOrgName());
        bizPilotAdvanceRecord.setUnitCode(ContextUtil.getCurrentOrgCode());
        bizPilotAdvanceRecord.setUnitGrade(ContextUtil.getCurrentOrgGrade());
        bizPilotAdvanceRecord.setStatus(0);
        bizPilotAdvanceRecord.setIsDele("0");

        //当再次更新时,生成新的附件
        if (BeanUtils.isEmpty(bizPilotAdvanceRecord.getId())&&BeanUtils.isNotEmpty(bizPilotAdvanceRecord.getIds())){
            List<DefaultFile> files = fileManager.list(new QueryWrapper<DefaultFile>().in("ID_",bizPilotAdvanceRecord.getIds()));
            for (DefaultFile file : files) {
                //将之前数据重新复制一份
                if (BeanUtils.isNotEmpty(file.getBizId())){
                    file.setId(null);
                    fileManager.save(file);
                }
            }
        }
        this.save(bizPilotAdvanceRecord);
       //更新验收材料附件
        if (bizPilotAdvanceRecord.getIds()!=null&&bizPilotAdvanceRecord.getIds().size()>0) universalWayManager.attachmentUpdates(bizPilotAdvanceRecord.getIds(),bizPilotAdvanceRecord.getId());

        if (BeanUtils.isNotEmpty(bizPilotAdvanceRecord.getResults())) {
            List<BizPilotAdvanceResult> recs = bizPilotAdvanceRecord.getResults();

            for (BizPilotAdvanceResult row : recs) {
                row.setRecordId(bizPilotAdvanceRecord.getId());
                row.setPilotId(bizPilotAdvanceRecord.getPilotId());
                Map<String, Integer> map = universalWayManager.setLocalDate(row.getResultDate());
                row.setResultQuarter(map.get("quarter"));
                row.setResultYear(map.get("year"));
                row.setResultMonth(map.get("month"));

                if (BeanUtils.isEmpty(row.getId())&&BeanUtils.isNotEmpty(row.getIds())){
                    List<DefaultFile> resFiles = fileManager.list(new QueryWrapper<DefaultFile>().in("ID_",row.getIds()));
                    for (DefaultFile file : resFiles) {
                        if (BeanUtils.isNotEmpty(file.getBizId())){
                            file.setId(null);
                            fileManager.save(file);
                        }
                    }
                }
                bizPilotAdvanceResultManager.save(row);
                //更新附件
                if (BeanUtils.isNotEmpty(row.getIds())) universalWayManager.attachmentUpdates(row.getIds(), row.getId());
                }
            }
        //记录操作日志
        setApprovalLog(bizPilotAdvanceRecord.getId(),null,bizPilotAdvanceRecord.getStatus(),null);
        //更新推进状态
        UpdateWrapper<BizReformPilotManagement> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id_",bizPilotAdvanceRecord.getPilotId());
        updateWrapper.set("PROPULSIVE_STATUS_",2);
        bizReformPilotManagementManager.update(updateWrapper);
        return  bizPilotAdvanceRecord.getId();
    }

    @Override
    @Transactional
    public void updateQuery(BizPilotAdvanceRecord bizPilotAdvanceRecord) {
        Assert.notNull(bizPilotAdvanceRecord.getId(),"推进信息id不能为空");
        Assert.notNull(bizPilotAdvanceRecord.getPilotId(),"试点项目id不能为空");
        String id = bizPilotAdvanceRecord.getId();
        String pilotId = bizPilotAdvanceRecord.getPilotId();

        this.update(bizPilotAdvanceRecord);
        //更新验收材料附件
        if (bizPilotAdvanceRecord.getIds()!=null&&bizPilotAdvanceRecord.getIds().size()>0) universalWayManager.attachmentUpdates(bizPilotAdvanceRecord.getIds(),id);
        //修改审批日志
        if (bizPilotAdvanceRecord.getStatus()==12||bizPilotAdvanceRecord.getStatus()==11) setApprovalLog(id,null,bizPilotAdvanceRecord.getStatus(),bizPilotAdvanceRecord.getApprovalComments());
        //修改试点成果
        if (BeanUtils.isNotEmpty(bizPilotAdvanceRecord.getResults())){
            bizPilotAdvanceResultManager.remove(new QueryWrapper<BizPilotAdvanceResult>().eq("RECORD_ID_",id).eq("IS_DELE_","0"));
            for (BizPilotAdvanceResult row : bizPilotAdvanceRecord.getResults()) {
                row.setRecordId(id);
                row.setPilotId(pilotId);
                Map<String, Integer> map = universalWayManager.setLocalDate(row.getResultDate());
                row.setResultQuarter(map.get("quarter"));
                row.setResultYear(map.get("year"));
                row.setResultMonth(map.get("month"));
                bizPilotAdvanceResultManager.saveOrUpdate(row);
                if (BeanUtils.isNotEmpty(row.getIds())){
                    universalWayManager.attachmentUpdates(row.getIds(),row.getId());
                }
            }
        }else {
            bizPilotAdvanceResultManager.remove(new QueryWrapper<BizPilotAdvanceResult>().eq("RECORD_ID_",id).eq("IS_DELE_","0"));
        }
        //更新状态
        if(bizPilotAdvanceRecord.getStatus()==12) verify(pilotId,bizPilotAdvanceRecord.getStatus());
    }


    /**
     * 设置审批日志实体类录入
     */
    private void setApprovalLog(String bizId,Integer approvalResults,Integer status,String approvalComments){
        // 审批日志
        BizPilotAdvanceRecord model = this.getOne(new QueryWrapper<BizPilotAdvanceRecord>().eq("ID_",bizId).eq("IS_DELE_", "0").last("LIMIT 1"));
        BizReformPilotManagement res = bizReformPilotManagementManager.getOne(new QueryWrapper<BizReformPilotManagement>().eq("ID_", model.getPilotId()).eq("IS_DELE_", "0").last("LIMIT 1"));
        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("ggsd_shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(bizId);
        logVo.setModeType(1);
        logVo.setModuleTableName("BIZ_PILOT_ADVANCE_RECORD");
        logVo.setApprovalResults(approvalResults);
        if (BeanUtils.isEmpty(approvalResults)){
            if (status%2==0){
                logVo.setApprovalResults(0);
            }else {
                logVo.setApprovalResults(1);
            }
            if (status==0){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】区县推进录入");
            } else if (status==6){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】提交本级审核");
            }else if (status==7){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】本级审核驳回");
            }else if (status==8){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】提交部门确认");
            }else if (status==9){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】部门审核驳回");
            }else if (status==10){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】提交改革办核准");
            }else if (status==11){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】改革办审核驳回");
            }else if (status==12){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】改革办审核通过");
            }
            logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, status));
        }else if (approvalResults==2){
            if (status==0){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】撤回为草稿");
                logVo.setOperateInfo("撤回为草稿");
            } else if (status==6){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】撤回为提交本级审核");
                logVo.setOperateInfo("撤回为提交本级审核");
            }else if (status==8){
                logVo.setItemTitle("【"+res.getPilotProjectName()+"】撤回为提交部门确认");
                logVo.setOperateInfo("撤回为提交部门确认");
            }else if (status==10) {
                logVo.setItemTitle("【" + res.getPilotProjectName() + "】撤回为提交改革办核准");
                logVo.setOperateInfo("撤回为提交改革办核准");
            }
        }
        logVo.setBizType("5");
        logVo.setStatus(status.toString());
        logVo.setApprovalComments(approvalComments);
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    /**
     * 更新时判断该数据是否还在审核中
     * @param id
     * @return
     */
    public int countNum(String id){
        int num =0;
        if (BeanUtils.isNotEmpty(id)){
            num=super.count(new QueryWrapper<BizPilotAdvanceRecord>()
                    .eq("PILOT_ID_",id)
                    .eq("UNIT_ID_",ContextUtil.getCurrentOrgId())
                    .eq("IS_DELE_", "0")
                    .in("STATUS_",6,8,10)
                    .orderByDesc("CREATE_TIME_")
                    .last("LIMIT 1"));
        }
        return num;
    }

    @Override
    public void updatePushStatus() {
        List<BizReformPilotManagement> list = bizReformPilotManagementManager.list(
                new QueryWrapper<BizReformPilotManagement>().eq("IS_DELE_", "0"));
        list.stream().forEach(p->{
            List<BizPilotAdvanceRecord> recList = super.list(new QueryWrapper<BizPilotAdvanceRecord>().eq("PILOT_ID_", p.getId()).eq("IS_DELE_", "0"));
            UpdateWrapper<BizReformPilotManagement> updateWrapper=new UpdateWrapper<>();
            if (BeanUtils.isEmpty(recList)){
                updateWrapper.eq("ID_",p.getId());
                updateWrapper.eq("IS_DELE_","0");
                updateWrapper.set("PROPULSIVE_STATUS_",1);
            }else {
                int invCount = bizReformInvolvedDistrictsManager.count(new QueryWrapper<BizReformInvolvedDistricts>()
                        .eq("PILOT_ID_", p.getId())
                        .groupBy("UNIT_ID_"));
                int recCount = super.count(new QueryWrapper<BizPilotAdvanceRecord>()
                        .eq("PILOT_ID_", p.getId())
                        .eq("IS_DELE_", "0")
                        .eq("PROPULSIVE_STATUS_", 3)
                        .eq("STATUS_",12)
                        .groupBy("UNIT_ID_"));
                if (invCount<=recCount){
                    //更新推进状态
                    updateWrapper.eq("id_",p.getId());
                    updateWrapper.eq("IS_DELE_","0");
                    updateWrapper.set("PROPULSIVE_STATUS_",3);
                }else {
                    updateWrapper.eq("ID_",p.getId());
                    updateWrapper.eq("IS_DELE_","0");
                    updateWrapper.set("PROPULSIVE_STATUS_",2);
                }
            }
            bizReformPilotManagementManager.update(updateWrapper);
        });
    }

    @Override
    public List<BizPilotAdvanceRecord> queryDeleteById(String id,String unitId) {
        Assert.notNull(id,"id不能为空");
        List<BizPilotAdvanceRecord> list = baseMapper.findDeleteId(id,unitId);
        if (list!=null&&list.size()>0){
            list.stream().forEach(p->{
                List<BizPilotAdvanceResult> results = bizPilotAdvanceResultManager.queryDeleteById(p.getId());
                if (results!=null&&results.size()>0)p.setResults(results);

                //从操作日志记录表中获取提交驳回意见
                AchieveStatusLog logCom = achieveStatusLogManager.getOne(new QueryWrapper<AchieveStatusLog>()
                        .eq("BIZ_ID_",p.getId())
                        .in("STATUS_",7,9,11)
                        .orderByDesc("OPERATE_DATE_")
                        .last("LIMIT 1"));
                if (BeanUtils.isNotEmpty(logCom)){
                    p.setApprovalComments(logCom.getApprovalComments());
                }

            });

        }
        return list;
    }

    /**
     * 验证填报区县是否全部验收,全部验收则更新推进状态
     * @param id
     * @return
     */
    private void verify(String id,Integer status){
        //查询试点项目涉及区县数量
        int invCount = bizReformInvolvedDistrictsManager.count(new QueryWrapper<BizReformInvolvedDistricts>().eq("pilot_id_", id));

        //查询试点项目已审核完成,且推进状态已验收的区县数量
        int recCount = baseMapper.recCount(id);

        if (BeanUtils.isNotEmpty(recCount)&&BeanUtils.isNotEmpty(invCount)&&invCount<=recCount&&status==12){
                //更新推进状态
                UpdateWrapper<BizReformPilotManagement> updateWrapper = new UpdateWrapper<>();
                updateWrapper.eq("id_",id);
                updateWrapper.set("PROPULSIVE_STATUS_",3);
                bizReformPilotManagementManager.update(updateWrapper);
        }

    }

    @Override
    public void editable(String pilotId, String unitId, Integer status){
        Assert.notNull(pilotId,"查询的试点id不能为空");
        Assert.notNull(unitId,"查询的区县不能为空");
        QueryWrapper<BizPilotAdvanceRecord> wrapper = new QueryWrapper<>();
        wrapper.eq("PILOT_ID_",pilotId);
        wrapper.eq("UNIT_ID_",unitId);
        wrapper.orderByDesc("CREATE_TIME_");
        wrapper.last("LIMIT 1");
        BizPilotAdvanceRecord entity = super.getOne(wrapper);
        if (status!=null&&BeanUtils.isNotEmpty(entity)){
            if (status!=entity.getStatus())throw new BaseException("该试点任务已被填写，请刷新后查看！！！");
        }
    }
}
