package com.artfess.reform.fill.manager.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.fill.manager.BizPilotAdvanceCityResultManager;
import com.artfess.reform.fill.model.BizPilotAdvanceCityRecord;
import com.artfess.reform.fill.dao.BizPilotAdvanceCityRecordDao;
import com.artfess.reform.fill.manager.BizPilotAdvanceCityRecordManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.model.BizPilotAdvanceCityResult;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 改革试点市级部门推进记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@Service
public class BizPilotAdvanceCityRecordManagerImpl extends BaseManagerImpl<BizPilotAdvanceCityRecordDao, BizPilotAdvanceCityRecord> implements BizPilotAdvanceCityRecordManager {
@Resource
    FileManager fileManager;
@Resource
    BizPilotAdvanceCityResultManager bizPilotAdvanceCityResultManager;
@Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Override
    public List<BizPilotAdvanceCityRecord> findByHistory(String pilotId) {
        List<BizPilotAdvanceCityRecord> list = super.list(new QueryWrapper<BizPilotAdvanceCityRecord>().eq("PILOT_ID_", pilotId).eq("IS_DELE_", "0").orderByDesc("CREATE_TIME_").last("LIMIT 2"));
        for (BizPilotAdvanceCityRecord bizPilotAdvanceCityRecord : list) {
            if (bizPilotAdvanceCityRecord!=null){
                List<BizPilotAdvanceCityResult> results = bizPilotAdvanceCityResultManager.list(new QueryWrapper<BizPilotAdvanceCityResult>().eq("RECORD_ID_", bizPilotAdvanceCityRecord.getId()).eq("IS_DELE_", "0"));
                if (results!=null&&results.size()>0){
                    bizPilotAdvanceCityRecord.setResults(results);
                    //查询成果附件
                    for (BizPilotAdvanceCityResult result : results) {
                        List<DefaultFile> files = fileManager.queryFileByBizId(result.getId());
                        result.setFiles(files);
                    }
                }
                //从操作日志记录表中获取提交驳回意见
                AchieveStatusLog logCom = achieveStatusLogManager.getOne(new QueryWrapper<AchieveStatusLog>()
                        .eq("BIZ_ID_",bizPilotAdvanceCityRecord.getId())
                        .orderByDesc("OPERATE_DATE_")
                        .last("LIMIT 1"));
                if (BeanUtils.isNotEmpty(logCom)){
                    bizPilotAdvanceCityRecord.setApprovalComments(logCom.getApprovalComments());
                }

            }
        }
        return list;
    }
}
