package com.artfess.reform.fill.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizMeetingEventPushDao;
import com.artfess.reform.fill.manager.BizMeetingEventDetailsManager;
import com.artfess.reform.fill.manager.BizMeetingEventPushManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizMeetingEventDetails;
import com.artfess.reform.fill.model.BizMeetingEventPush;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotExperiencePush;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:会议议定事项推进表 服务实现类
 * @Author: Rong Tao
 * @Date: 2023/4/3 17:15
 */
@Service
public class BizMeetingEventPushManagerImpl extends BaseManagerImpl<BizMeetingEventPushDao, BizMeetingEventPush> implements BizMeetingEventPushManager {

    @Resource
    FileManager fileManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    private BizMeetingEventDetailsManager bizMeetingEventDetailsManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    private UniversalWayManager universalWayManager;

//    @Override
//    @Transactional
//    public void saveOrUpdateList(List<BizMeetingEventPush> bizMeetingEventPushList) {
//        bizMeetingEventPushList.stream().forEach(p->{
//            Map<String, Integer> map = universalWayManager.setDate(p.getFeedbackDate());
//            p.setFeedbackYear(map.get("year"));
//            p.setFeedbackMonth(map.get("month"));
//            p.setFeedbackQuarter(map.get("quarter"));
//            p.setFeedbackWeek(map.get("week"));
//        });
//        super.saveOrUpdateBatch(bizMeetingEventPushList);
//        for(BizMeetingEventPush mep: bizMeetingEventPushList){
//            List<DefaultFile> files = mep.getFiles();
//            if(null != files && files.size() > 0){
//                List<String> fileList = files.stream().map(f -> f.getId()).collect(Collectors.toList());
//                // 修改附件bizId
//                fileManager.updateFileBizIdByIds(fileList, mep.getId());
//            }
//        }
//    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizMeetingEventPush bizMeetingEventPush) {
        Map<String, Integer> map = universalWayManager.setDate(new Date());
        bizMeetingEventPush.setFeedbackDate(new Date());
        bizMeetingEventPush.setFeedbackYear(map.get("year"));
        bizMeetingEventPush.setFeedbackMonth(map.get("month"));
        bizMeetingEventPush.setFeedbackQuarter(map.get("quarter"));
        bizMeetingEventPush.setFeedbackWeek(map.get("week"));
        String id = bizMeetingEventPush.getId();
        super.saveOrUpdate(bizMeetingEventPush);
        if(BeanUtils.isEmpty(id)||(BeanUtils.isNotEmpty(id)&&bizMeetingEventPush.getStatus()!=0))setApprovalLog(bizMeetingEventPush.getId(),bizMeetingEventPush.getDetailsId(),null,bizMeetingEventPush.getStatus(),null);
        // 修改附件bizId
        List<DefaultFile> files = bizMeetingEventPush.getFiles();
        if(null != files && files.size() > 0){
            List<String> fileList = files.stream().map(f -> f.getId()).collect(Collectors.toList());
            fileManager.updateFileBizIdByIds(fileList, bizMeetingEventPush.getId());
        }

    }

    @Override
    public PageList<BizMeetingEventPush> queryByPage(QueryFilter<BizMeetingEventPush> queryFilter) {
        if(BizUtils.isAdmin(ucFeignService)) queryFilter.addFilter("UNIT_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        PageList<BizMeetingEventPush> result = super.query(queryFilter);
        List<BizMeetingEventPush> rows = result.getRows();
        if(BeanUtils.isNotEmpty(rows) && rows.size()>0){
            rows.stream().forEach(s->s.setFiles(fileManager.queryFileByBizId(s.getId())));
        }
        return result;
    }

    @Override
    public BizMeetingEventPush detailedById(String id) {
        BizMeetingEventPush result = super.getById(id);
        result.setFiles(fileManager.queryFileByBizId(id));
        return result;
    }

    @Override
    @Transactional
    public boolean modifyStatus(String id,String projectId, Integer approvalResults ,String status) {
        UpdateWrapper<BizMeetingEventPush> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("STATUS_",status).eq("ID_", id);
        setApprovalLog(id,projectId,approvalResults,Integer.parseInt(status),null);
        return super.update(updateWrapper);
    }

    @Override
    public List<BizMeetingEventPush> queryHistory(QueryFilter<BizMeetingEventPush> queryFilter) {

        //查询推进表最近操作的两条数据
        queryFilter.addFilter("IS_DELE_","0",QueryOP.EQUAL);
        List<BizMeetingEventPush> result = super.query(queryFilter).getRows();

        if(BeanUtils.isNotEmpty(result) && result.size()>0){
            for(BizMeetingEventPush mep : result){
                if(BeanUtils.isNotEmpty(mep.getStatus())){
                        QueryWrapper<AchieveStatusLog> logQW = new QueryWrapper<>();
                        logQW.eq("BIZ_ID_",mep.getId())
                             .eq("APPROVAL_RESULTS_",1)
                             .orderByDesc("LAST_TIME_")
                             .last("limit 1");
                        AchieveStatusLog achieveStatusLog = achieveStatusLogManager.getBaseMapper().selectOne(logQW);
                        if (BeanUtils.isNotEmpty(achieveStatusLog)) mep.setApprovalComments(achieveStatusLog.getApprovalComments());
                }
                List<DefaultFile> files = fileManager.queryFileByBizId(mep.getId());
                mep.setFiles(files);
            }
        }

        return result;
    }

    @Override
    @Transactional
    public void examineAndVerify(BizMeetingEventPush bizMeetingEventPush) {
        setApprovalLog(bizMeetingEventPush.getId(),bizMeetingEventPush.getDetailsId(),bizMeetingEventPush.getApprovalResults(),bizMeetingEventPush.getStatus(),bizMeetingEventPush.getApprovalComments());
        super.updateById(bizMeetingEventPush);
        // 修改附件bizId
        List<DefaultFile> files = bizMeetingEventPush.getFiles();
        if(null != files && files.size() > 0){
            List<String> fileList = files.stream().map(f -> f.getId()).collect(Collectors.toList());
            fileManager.updateFileBizIdByIds(fileList, bizMeetingEventPush.getId());
        }
        //如果审核状态为审核通过并且推进状态不为未启动，更新会议详情表推进状态
        if(bizMeetingEventPush.getAbutmentStatus()!=1 && bizMeetingEventPush.getStatus()==5){
            UpdateWrapper<BizMeetingEventDetails> detailsUW = new UpdateWrapper<>();
            detailsUW.set("ABUTMENT_STATUS_",bizMeetingEventPush.getAbutmentStatus())
                    .eq("ID_",bizMeetingEventPush.getDetailsId())
                    .ne("ABUTMENT_STATUS_",bizMeetingEventPush.getAbutmentStatus());
            bizMeetingEventDetailsManager.update(detailsUW);
        }
    }

    /**
     * 设置审批日志实体类录入
     *
     * @param id
     * @param status
     */
    @Transactional
    public void setApprovalLog(String id,String projectId, Integer approvalResults,Integer status,String approvalComments) {
        // 审批日志
        BizMeetingEventDetails details = bizMeetingEventDetailsManager.getById(projectId);
        String title = details.getMeetingTask();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("9");
        logVo.setApprovalComments(approvalComments);
        logVo.setModuleTableName("BIZ_MEETING_EVENT_PUSH");
        if (BeanUtils.isNotEmpty(approvalResults)&&approvalResults==2){
            if (status==0){
                logVo.setItemTitle("【"+title+"】撤回为草稿！");
                logVo.setOperateInfo("撤回为草稿");
            } else if (status==1){
                logVo.setItemTitle("【"+title+"】撤回为提交本级审核！");
                logVo.setOperateInfo("撤回为提交本级审核");
            } else if(status==3){
                logVo.setItemTitle("【"+title+"】撤回为本级审核通过！");
                logVo.setOperateInfo("撤回为本级审核通过");
            }
            logVo.setApprovalResults(2);
        }else {
            //审核状态：2.审核驳回，3.审核通过
            if (status==0){
                logVo.setItemTitle("【"+title+"】创建录入！");
                logVo.setOperateInfo("保存为草稿");
                logVo.setApprovalResults(0);
            } else if (status==1){
                logVo.setItemTitle("【"+title+"】提交本级审核！");
                logVo.setOperateInfo("提交本级审核");
                logVo.setApprovalResults(0);
            } else if(status==2){
                logVo.setItemTitle("【"+title+"】本级审核驳回！");
                logVo.setOperateInfo("本级审核驳回");
                logVo.setApprovalResults(1);
            }else if(status==3){
                logVo.setItemTitle("【"+title+"】本级审核通过！");
                logVo.setOperateInfo("本级审核通过");
                logVo.setApprovalResults(0);
            }else if (status==4){
                logVo.setItemTitle("【"+title+"】改革办确认驳回！");
                logVo.setOperateInfo("改革办确认驳回");
                logVo.setApprovalResults(1);
            }else if (status==5){
                logVo.setItemTitle("【"+title+"】改革办确认通过！");
                logVo.setOperateInfo("改革办确认通过");
                logVo.setApprovalResults(0);
            }
        }

        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

}
