package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.dao.BizEffectEffectivenessDao;
import com.artfess.reform.fill.manager.BizEffectDryingCompetitionManager;
import com.artfess.reform.fill.manager.BizEffectEffectivenessManager;
import com.artfess.reform.fill.model.BizEffectDryingCompetition;
import com.artfess.reform.fill.model.BizEffectEffectiveness;
import com.artfess.reform.statistics.vo.CountyCityPromotionVo;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 成效晾晒比拼具体情形表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
@Service
public class BizEffectEffectivenessManagerImpl extends BaseManagerImpl<BizEffectEffectivenessDao, BizEffectEffectiveness> implements BizEffectEffectivenessManager {

    @Resource
    private OrgManager orgManager;
    @Resource
    private BizEffectDryingCompetitionManager effectDryingCompetitionManager;

    /**
     * 重写 list 查询方法以用code关联组织
     * @param queryWrapper 实体对象封装操作类 {@link com.baomidou.mybatisplus.core.conditions.query.QueryWrapper}
     * @return data
     */
    @Override
    public List<BizEffectEffectiveness> list(Wrapper<BizEffectEffectiveness> queryWrapper) {
        List<BizEffectEffectiveness> data = super.list(queryWrapper);
        List<Org> orgList = orgManager.list();
        List<BizEffectDryingCompetition> mainData = effectDryingCompetitionManager.list();
        data.forEach(d -> {
            d.setOrgCode(orgList.stream().filter(o -> d.getCreateOrgId().equals(o.getId())).findFirst().map(Org::getCode).orElse(null));
            d.setEffectTopic(mainData.stream().filter(m->d.getEffectId().equals(m.getId())).findFirst().map(BizEffectDryingCompetition::getEffectCardTopic).orElse(null));
            mainData.forEach(md->{});
        });
        return data;
    }
    /**
     * 重写 list 查询方法以用code关联组织、topic
     * @return data
     */
    @Override
    public List<BizEffectEffectiveness> list() {
        List<BizEffectEffectiveness> data = super.list();
        List<Org> orgList = orgManager.list();
        List<BizEffectDryingCompetition> mainData = effectDryingCompetitionManager.list();
        data.forEach(d -> {
            d.setOrgCode(orgList.stream().filter(o -> d.getCreateOrgId().equals(o.getId())).findFirst().map(Org::getCode).orElse(null));
            d.setEffectTopic(mainData.stream().filter(m->d.getEffectId().equals(m.getId())).findFirst().map(BizEffectDryingCompetition::getEffectCardTopic).orElse(null));
            mainData.forEach(md->{});
        });
        return data;
    }

    @Override
    public List<CountyCityPromotionVo> cityPromotionRank(String time) {
        return baseMapper.cityPromotionRank(time);
    }

    @Override
    public PageList<BizEffectEffectiveness> cityPromotionDetail(QueryFilter<BizEffectEffectiveness> queryFilter) {
        QueryWrapper<BizEffectEffectiveness> queryWrapper = (QueryWrapper<BizEffectEffectiveness>) convert2Wrapper(queryFilter, BizEffectEffectiveness.class);
        queryWrapper.eq("STATUS_", 5);
        IPage<BizEffectEffectiveness> page = baseMapper.cityPromotionDetail(convert2IPage(queryFilter.getPageBean()), queryWrapper);
        return new PageList<>(page);
    }

    @Override
    public List<BizEffectEffectiveness> brandDetails(String unitId, int year,int quarter,QueryFilter<BizEffectEffectiveness> queryFilter) {
        return baseMapper.brandDetails(unitId,year,quarter,convert2Wrapper(queryFilter,currentModelClass()));
    }
}
