package com.artfess.reform.fill.manager.impl;

import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizEffectEffectivenessDao;
import com.artfess.reform.fill.manager.BizEffectEffectivenessManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizEffectDryingCompetition;
import com.artfess.reform.fill.dao.BizEffectDryingCompetitionDao;
import com.artfess.reform.fill.manager.BizEffectDryingCompetitionManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.model.BizEffectEffectiveness;
import com.artfess.reform.fill.vo.EffectDryingCompetitionExportVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * 成效晾晒比拼（品牌显示度） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
@Service
public class BizEffectDryingCompetitionManagerImpl extends BaseManagerImpl<BizEffectDryingCompetitionDao, BizEffectDryingCompetition> implements BizEffectDryingCompetitionManager {

    @Resource
    private BizEffectEffectivenessManager effectEffectivenessManager;
    @Resource
    private UniversalWayManager universalWayManager;
    @Resource
    private BizEffectEffectivenessDao effectEffectivenessDao;
    @Resource
    private FileManager fileManager;
    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Override
    @Transactional
    public String inertInfo(BizEffectDryingCompetition effectDrying) {
        this.saveOrUpdate(effectDrying);
        List<BizEffectEffectiveness> records = effectDrying.getRecords();
        if(BeanUtils.isNotEmpty(records)){
            for (BizEffectEffectiveness model : records){
                if(model.getStatus() ==null){
                    model.setStatus(0);
                }

                model.setEffectId(effectDrying.getId());
                LocalDate completionDate = model.getCompletionDate();
                if(completionDate == null){
                    completionDate = LocalDate.now();
                }
                model.setCompletionYear(completionDate.getYear());
                model.setCompletionQuarter(Integer.valueOf(completionDate.getMonthValue() + 2) / 3);
                model.setCompletionMonth(completionDate.getMonthValue());

                //添加是否满足操作日志记录条件
                effectEffectivenessManager.saveOrUpdate(model);
                if (model.getIds()!=null && model.getIds().size()>0){
                    universalWayManager.attachmentUpdates(model.getIds(), model.getId());
                }
                setApprovalLog(model.getId(), effectDrying.getId(), model.getStatus(),"",model.getApprovalResults());
            }
        }

        return effectDrying.getId();
    }

    @Override
    @Transactional
    public CommonResult<String> updateInfo(BizEffectDryingCompetition effectDryingCompetition) {

        List<BizEffectEffectiveness> records = effectDryingCompetition.getRecords();
        if(BeanUtils.isNotEmpty(records)){
            for (BizEffectEffectiveness model : records){
                model.setEffectId(effectDryingCompetition.getId());
                if (model.getIds()!=null && model.getIds().size()>0){
                    universalWayManager.attachmentUpdates(model.getIds(), model.getId());
                }
                //判断是否满足记录操作日志条件,避免重复记录
                boolean check = check(model);
                this.effectEffectivenessDao.updateById(model);
                //记录操作日志
                if(check)setApprovalLog(model.getId(), model.getEffectId(), model.getStatus(),model.getApprovalComments(),model.getApprovalResults());
            }
        }
        this.baseMapper.updateById(effectDryingCompetition);
        return new CommonResult<>(true,"修改成功！");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteById(String id) {
        Assert.hasText(id,"ID不能为空！");
        QueryWrapper<BizEffectEffectiveness> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("EFFECT_ID_", id).notIn("STATUS_",Arrays.asList(0,2,4));
        int num = effectEffectivenessDao.selectCount(queryWrapper);
        if (num>0){
            return new CommonResult<String>(false,"已提交审核无法删除");
        }
        this.baseMapper.deleteById(id);
        QueryWrapper<BizEffectEffectiveness> delWrapper = new QueryWrapper<>();
        delWrapper.eq("EFFECT_ID_", id);
        effectEffectivenessDao.delete(delWrapper);
        return new CommonResult<>(true,"删除成功！");

    }

    @Override
    public PageList<EffectDryingCompetitionExportVo> queryAudit(QueryFilter<BizEffectDryingCompetition> queryFilter,String status) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<EffectDryingCompetitionExportVo> result=baseMapper.queryAudit(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()),status);
        return new PageList<>(result);
    }

    @Override
    public PageList<EffectDryingCompetitionExportVo> queryGroup(QueryFilter<BizEffectDryingCompetition> queryFilter, String code) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<EffectDryingCompetitionExportVo> result=baseMapper.queryGroup(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()),code);
        return new PageList<>(result);
    }

    @Override
    public BizEffectDryingCompetition queryById(String id) {
        Assert.hasText(id,"ID不能为空！");
        BizEffectDryingCompetition effectDryingCompetition = this.baseMapper.selectById(id);
        QueryWrapper<BizEffectEffectiveness> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("EFFECT_ID_", id);
        List<BizEffectEffectiveness> list = this.effectEffectivenessDao.selectList(queryWrapper);
        if(BeanUtils.isNotEmpty(list)){
            for(BizEffectEffectiveness record:list){
                if(record.getStatus()==2 || record.getStatus()==4){//驳回查询驳回意见
                    AchieveStatusLog log = achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(record.getId(),record.getStatus());
                    record.setApprovalComments(log.getApprovalComments());
                }
                QueryWrapper<DefaultFile> fileQuery = new QueryWrapper<>();
                fileQuery.eq("biz_id_",record.getId());
                List<DefaultFile> filesList = fileManager.list(fileQuery);
                record.setFiles(filesList);
            }
            effectDryingCompetition.setRecords(list);
        }
        return effectDryingCompetition;
    }

    @Override
    @Transactional
    public void updateAuditStatus(BizEffectEffectiveness record) {
        //判断是否满足记录操作日志条件,避免重复记录
        boolean check = check(record);
        this.effectEffectivenessDao.updateById(record);
        //记录操作日志
        if(check)setApprovalLog(record.getId(), record.getEffectId(), record.getStatus(),record.getApprovalComments(),record.getApprovalResults());
    }

    /**
     * 设置审批日志实体类录入
     *
     * @param id
     * @param status
     */
    @Transactional
    public void setApprovalLog(String id,String effectId, Integer status,String approvalComments,Integer approvalResults) {
        // 审批日志
        BizEffectDryingCompetition effectDrying =  this.baseMapper.selectById(effectId);
        String title = effectDrying.getEffectCardTopic();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("4");
        logVo.setApprovalComments(approvalComments);
        logVo.setModuleTableName("biz_effect_effectiveness");

        //0：草稿，1：已录入待审核，2：审核驳回，3：审核通过【改革办待审核】 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成
        if (approvalResults!=null&&approvalResults==2){
            if(status==0){
                logVo.setItemTitle("【"+title+"】撤回为草稿状态！");
                logVo.setOperateInfo("撤回为草稿状态！");
                logVo.setApprovalResults(2);
            }else if(status==1){
                logVo.setItemTitle("【"+title+"】撤回为提交审核！");
                logVo.setOperateInfo("撤回为提交审核");
                logVo.setApprovalResults(2);
            }else if(status==3){
                logVo.setItemTitle("【"+title+"】撤回为审核通过！");
                logVo.setOperateInfo("撤回为审核通过");
                logVo.setApprovalResults(2);
            }
        }else {
            if(status==0){
                logVo.setItemTitle("【"+title+"】录入！");
                logVo.setOperateInfo("成效晾晒信息录入！");
                logVo.setApprovalResults(0);
            }else if(status==1){
                logVo.setItemTitle("【"+title+"】提交审核！");
                logVo.setOperateInfo("提交审核");
                logVo.setApprovalResults(0);
            }else if(status==2){
                logVo.setItemTitle("【"+title+"】审核驳回！");
                logVo.setOperateInfo("审核驳回");
                logVo.setApprovalResults(1);
            }else if(status==3){
                logVo.setItemTitle("【"+title+"】审核通过！");
                logVo.setOperateInfo("审核通过");
                logVo.setApprovalResults(0);
            }else if(status==4){
                logVo.setItemTitle("【"+title+"】改革办驳回！");
                logVo.setOperateInfo("改革办驳回");
                logVo.setApprovalResults(1);
            }else if(status==5){
                logVo.setItemTitle("【"+title+"】改革办通过！");
                logVo.setOperateInfo("改革办通过");
                logVo.setApprovalResults(0);
            }
        }


        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    boolean check(BizEffectEffectiveness record){
        //判断是否满足记录操作日志条件,避免重复记录
        BizEffectEffectiveness entity = this.effectEffectivenessManager.getOne(
                new QueryWrapper<BizEffectEffectiveness>()
                        .eq("ID_", record.getId())
                        .eq("IS_DELE_", "0"), false);
        return entity==null||entity.getStatus()!=record.getStatus();
    }
}
