package com.artfess.reform.fill.manager.impl;


import com.artfess.base.query.*;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.manager.BizDigitalThreeListsManager;

import com.artfess.reform.fill.model.BizDigitalThreeLists;
import com.artfess.reform.fill.dao.BizDigitalThreeListsDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 围绕三张清单情况 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
@Service
public class BizDigitalThreeListsManagerImpl extends BaseManagerImpl<BizDigitalThreeListsDao, BizDigitalThreeLists> implements BizDigitalThreeListsManager {
@Resource
    FileManager fileManager;
    @Override
    public List<BizDigitalThreeLists> selectByUnitId(String unitId) {
        List<BizDigitalThreeLists> list = baseMapper.selectByUnitId(unitId);
        list.stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
    }

    @Override
    public List<BizDigitalThreeLists> selectAuditById(String id) {
        List<BizDigitalThreeLists> list = baseMapper.selectAuditById(id);
        list.stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
    }

    @Override
    public List<BizDigitalThreeLists> selectExamineById(String id,String unitId) {
        List<BizDigitalThreeLists> list = baseMapper.selectExamineById(id,unitId);
        list.stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
}

    @Override
    public PageList<BizDigitalThreeLists> queryByPage(QueryFilter<BizDigitalThreeLists> queryFilter) {
            queryFilter.addFilter("t.NUM",1, QueryOP.EQUAL);
            List<FieldSort> sorter = queryFilter.getSorter();
            sorter.add(new FieldSort("t.CREATE_ORG_ID_", Direction.ASC));
            queryFilter.setSorter(sorter);
            IPage<BizDigitalThreeLists> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
            iPage.getRecords().stream().forEach(p->{
                List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
                p.setFiles(files);
            });
            return new PageList<>(iPage);
    }

    @Override
    public PageList<BizDigitalThreeLists> queryByPageNew(QueryFilter<BizDigitalThreeLists> queryFilter) {
        queryFilter.addFilter("t.NUM",1, QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("t.CREATE_ORG_ID_", Direction.ASC));
        queryFilter.setSorter(sorter);
        IPage<BizDigitalThreeLists> iPage = baseMapper.queryByPageNew(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        iPage.getRecords().stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return new PageList<>(iPage);
    }
}
