package com.artfess.reform.fill.manager.impl;

import com.artfess.base.query.*;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.manager.BizDigitalOnLineApplicationManager;
import com.artfess.reform.fill.model.BizDigitalOnLineApplication;
import com.artfess.reform.fill.dao.BizDigitalOnLineApplicationDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 开发上线特色应用情况 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
@Service
public class BizDigitalOnLineApplicationManagerImpl extends BaseManagerImpl<BizDigitalOnLineApplicationDao, BizDigitalOnLineApplication> implements BizDigitalOnLineApplicationManager {
    @Resource
    FileManager fileManager;
    @Override
    public List<BizDigitalOnLineApplication> selectByUnitId(String unitId) {
        List<BizDigitalOnLineApplication> list = baseMapper.selectByUnitId(unitId);
        list.stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
    }

    @Override
    public List<BizDigitalOnLineApplication> selectAuditById(String id) {
        List<BizDigitalOnLineApplication> list = baseMapper.selectAuditById(id);
        list.stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
    }

    @Override
    public List<BizDigitalOnLineApplication> selectExamineById(String id,String unitId) {
        List<BizDigitalOnLineApplication> list = baseMapper.selectExamineById(id,unitId);
        list.stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
    }

    @Override
    public PageList<BizDigitalOnLineApplication> queryByPage(QueryFilter<BizDigitalOnLineApplication> queryFilter) {
        queryFilter.addFilter("o.NUM",1,QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("o.CREATE_ORG_ID_", Direction.ASC));
        queryFilter.setSorter(sorter);
        IPage<BizDigitalOnLineApplication> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        iPage.getRecords().stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizDigitalOnLineApplication> queryByPageNew(QueryFilter<BizDigitalOnLineApplication> queryFilter) {
        queryFilter.addFilter("o.NUM",1,QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("o.CREATE_ORG_ID_", Direction.ASC));
        queryFilter.setSorter(sorter);
        IPage<BizDigitalOnLineApplication> iPage = baseMapper.queryByPageNew(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        iPage.getRecords().stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return new PageList<>(iPage);
    }
}
