package com.artfess.reform.fill.manager.impl;


import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.manager.*;
import com.artfess.reform.fill.model.*;
import com.artfess.reform.fill.dao.BizDigitalConstructionDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.artfess.uc.api.impl.util.ContextUtil;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 推动数字重庆建设 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
@Service
public class BizDigitalConstructionManagerImpl extends BaseManagerImpl<BizDigitalConstructionDao, BizDigitalConstruction> implements BizDigitalConstructionManager {
    @Resource
    BizDigitalOneThingManager bizDigitalOneThingManager;
    @Resource
    BizDigitalThreeListsManager bizDigitalThreeListsManager;
    @Resource
    BizDigitalOnLineApplicationManager bizDigitalOnLineApplicationManager;
    @Resource
    BizDigitalShareApplicationManager bizDigitalShareApplicationManager;
    @Resource
    BizDigitalAdvanceConstructionManager bizDigitalAdvanceConstructionManager;
    @Resource
    UniversalWayManager universalWayManager;
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    FileManager fileManager;

    @Override
    @Transactional
    public void create(BizDigitalConstruction bizDigitalConstruction) {
        Assert.notNull(bizDigitalConstruction, "信息不能为空!!!");
        Assert.isTrue(BeanUtils.isNotEmpty(bizDigitalConstruction.getBizDigitalOneThingList())||BeanUtils.isNotEmpty(bizDigitalConstruction.getBizDigitalThreeListsList())||BeanUtils.isNotEmpty(bizDigitalConstruction.getBizDigitalOnLineApplicationList())||BeanUtils.isNotEmpty(bizDigitalConstruction.getBizDigitalShareApplicationList()), "信息不能为空!!!");
        boolean chick = true;
        String id = bizDigitalConstruction.getId();
        //判断再次更新时,新增一条数据
        if (id != null) {
            BizDigitalConstruction entity = super.getById(id);
            if (entity!=null&&entity.getStatus() == bizDigitalConstruction.getStatus()) chick = false;
            if (entity!=null&&entity.getStatus() == 4 && (bizDigitalConstruction.getStatus() == 0 || bizDigitalConstruction.getStatus() == 1))
                bizDigitalConstruction.setId(null);
        }
        //设置填报时间
        if (bizDigitalConstruction.getId()==null){
            LocalDate now = LocalDate.now();
            bizDigitalConstruction.setFillYear(now.getYear());
            bizDigitalConstruction.setFillMonth(now.getMonthValue());
            bizDigitalConstruction.setFillQuarter((now.getMonthValue() + 2) / 3);
            bizDigitalConstruction.setFillDate(Date.valueOf(now));
            bizDigitalConstruction.setUnitId(ContextUtil.getCurrentOrgId());
            bizDigitalConstruction.setUnitCode(ContextUtil.getCurrentOrgCode());
            bizDigitalConstruction.setUnitName(ContextUtil.getCurrentOrgName());
            bizDigitalConstruction.setUnitGrade(ContextUtil.getCurrentOrgGrade());
        }
        super.saveOrUpdate(bizDigitalConstruction);
        //记录操作日志
        if (id == null || chick) setApprovalLog(bizDigitalConstruction);
        //添加围绕重点领域策划推出“一件事”情况
        if (bizDigitalConstruction.getBizDigitalOneThingList() != null && bizDigitalConstruction.getBizDigitalOneThingList().size() > 0) {
            List<BizDigitalOneThing> list = bizDigitalConstruction.getBizDigitalOneThingList();
            bizDigitalOneThingManager.saveOrUpdateBatch(list);
            list.stream().forEach(t -> {
                //判断是否存在原始数据id,如果不存在，则将第一次新增的id赋值原始id
                if (t.getOriginalId() == null) {
                    UpdateWrapper<BizDigitalOneThing> updateWrapper = new UpdateWrapper<>();
                    updateWrapper.eq("ID_", t.getId());
                    updateWrapper.set("ORIGINAL_ID_", t.getId());
                    bizDigitalOneThingManager.update(updateWrapper);
                }
                //计入推进表
                boolean exist = isExist(t.getId());
                if (exist) {
                    BizDigitalAdvanceConstruction entity = new BizDigitalAdvanceConstruction();
                    entity.setDigitalId(bizDigitalConstruction.getId());
                    entity.setPushId(t.getId());
                    entity.setCategoryType(1);
                    bizDigitalAdvanceConstructionManager.saveOrUpdate(entity);
                }
                //更新附件
                if (t.getFiles() != null && t.getFiles().size() > 0) {
                    for (DefaultFile file : t.getFiles()) {
                        //将之前数据重新复制一份
                        if (BeanUtils.isNotEmpty(file.getBizId())&&!file.getBizId().equals(t.getId())){
                            file.setId(null);
                            fileManager.save(file);
                        }
                    }
                    List<String> ids = t.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                    universalWayManager.attachmentUpdates(ids, t.getId());
                }
            });
        }
        //编制应用“三张清单”情况
        if (bizDigitalConstruction.getBizDigitalThreeListsList() != null && bizDigitalConstruction.getBizDigitalThreeListsList().size() > 0) {
            List<BizDigitalThreeLists> list = bizDigitalConstruction.getBizDigitalThreeListsList();
            bizDigitalThreeListsManager.saveOrUpdateBatch(list);
            list.stream().forEach(t -> {
                //判断是否存在原始数据id,如果不存在，则将第一次新增的id赋值原始id
                if (t.getOriginalId() == null) {
                    UpdateWrapper<BizDigitalThreeLists> updateWrapper = new UpdateWrapper<>();
                    updateWrapper.eq("ID_", t.getId());
                    updateWrapper.set("ORIGINAL_ID_", t.getId());
                    bizDigitalThreeListsManager.update(updateWrapper);
                }
                //计入推进表
                boolean exist = isExist(t.getId());
                if (exist) {
                    BizDigitalAdvanceConstruction entity = new BizDigitalAdvanceConstruction();
                    entity.setDigitalId(bizDigitalConstruction.getId());
                    entity.setPushId(t.getId());
                    entity.setCategoryType(2);
                    bizDigitalAdvanceConstructionManager.saveOrUpdate(entity);
                }
                //更新附件
                if (t.getFiles() != null && t.getFiles().size() > 0) {
                    for (DefaultFile file : t.getFiles()) {
                        //将之前数据重新复制一份
                        if (BeanUtils.isNotEmpty(file.getBizId())&&!file.getBizId().equals(t.getId())){
                            file.setId(null);
                            fileManager.save(file);
                        }
                    }
                    List<String> ids = t.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                    universalWayManager.attachmentUpdates(ids, t.getId());
                }
            });
        }

        //开发上线特色应用情况
        if (bizDigitalConstruction.getBizDigitalOnLineApplicationList() != null && bizDigitalConstruction.getBizDigitalOnLineApplicationList().size() > 0) {
            List<BizDigitalOnLineApplication> list = bizDigitalConstruction.getBizDigitalOnLineApplicationList();
            bizDigitalOnLineApplicationManager.saveOrUpdateBatch(list);
            list.stream().forEach(t -> {
                //判断是否存在原始数据id,如果不存在，则将第一次新增的id赋值原始id
                if (t.getOriginalId() == null) {
                    UpdateWrapper<BizDigitalOnLineApplication> updateWrapper = new UpdateWrapper<>();
                    updateWrapper.eq("ID_", t.getId());
                    updateWrapper.set("ORIGINAL_ID_", t.getId());
                    bizDigitalOnLineApplicationManager.update(updateWrapper);
                }
                //计入推进表
                boolean exist = isExist(t.getId());
                if (exist) {
                    BizDigitalAdvanceConstruction entity = new BizDigitalAdvanceConstruction();
                    entity.setDigitalId(bizDigitalConstruction.getId());
                    entity.setPushId(t.getId());
                    entity.setCategoryType(3);
                    bizDigitalAdvanceConstructionManager.saveOrUpdate(entity);
                }
                //更新附件
                if (t.getFiles() != null && t.getFiles().size() > 0) {
                    for (DefaultFile file : t.getFiles()) {
                        //将之前数据重新复制一份
                        if (BeanUtils.isNotEmpty(file.getBizId())&&!file.getBizId().equals(t.getId())){
                            file.setId(null);
                            fileManager.save(file);
                        }
                    }
                    List<String> ids = t.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                    universalWayManager.attachmentUpdates(ids, t.getId());
                }
            });
        }
        //特色应用“一地创新、全市共享”情况
        if (bizDigitalConstruction.getBizDigitalShareApplicationList() != null && bizDigitalConstruction.getBizDigitalShareApplicationList().size() > 0) {
            List<BizDigitalShareApplication> list = bizDigitalConstruction.getBizDigitalShareApplicationList();
            bizDigitalShareApplicationManager.saveOrUpdateBatch(list);
            list.stream().forEach(t -> {
                //判断是否存在原始数据id,如果不存在，则将第一次新增的id赋值原始id
                if (t.getOriginalId() == null) {
                    UpdateWrapper<BizDigitalShareApplication> updateWrapper = new UpdateWrapper<>();
                    updateWrapper.eq("ID_", t.getId());
                    updateWrapper.set("ORIGINAL_ID_", t.getId());
                    bizDigitalShareApplicationManager.update(updateWrapper);
                }
                //计入推进表
                boolean exist = isExist(t.getId());
                if (exist) {
                    BizDigitalAdvanceConstruction entity = new BizDigitalAdvanceConstruction();
                    entity.setDigitalId(bizDigitalConstruction.getId());
                    entity.setPushId(t.getId());
                    entity.setCategoryType(4);
                    bizDigitalAdvanceConstructionManager.saveOrUpdate(entity);
                }
                //更新附件
                if (t.getFiles() != null && t.getFiles().size() > 0) {
                    for (DefaultFile file : t.getFiles()) {
                        //将之前数据重新复制一份
                        if (BeanUtils.isNotEmpty(file.getBizId())&&!file.getBizId().equals(t.getId())){
                            file.setId(null);
                            fileManager.save(file);
                        }
                    }
                    List<String> ids = t.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                    universalWayManager.attachmentUpdates(ids, t.getId());
                }
            });
        }

    }

    @Transactional
    public boolean updateByStatus(BizDigitalConstruction bizDigitalConstruction) {
        Assert.notNull(bizDigitalConstruction.getId(), "需审核的id不能为空");
        Assert.notNull(bizDigitalConstruction.getStatus(), "需审核的状态不能为空");
        Assert.isTrue(BeanUtils.isNotEmpty(bizDigitalConstruction.getBizDigitalOneThingList())||BeanUtils.isNotEmpty(bizDigitalConstruction.getBizDigitalThreeListsList())||BeanUtils.isNotEmpty(bizDigitalConstruction.getBizDigitalOnLineApplicationList())||BeanUtils.isNotEmpty(bizDigitalConstruction.getBizDigitalShareApplicationList()),"暂无上传数据!!!");
        BizDigitalConstruction entity = super.getById(bizDigitalConstruction.getId());
        boolean check=entity==null||bizDigitalConstruction.getStatus()!=entity.getStatus();
        UpdateWrapper<BizDigitalConstruction> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("ID_", bizDigitalConstruction.getId());
        updateWrapper.set("STATUS_", bizDigitalConstruction.getStatus());
        super.saveOrUpdate(bizDigitalConstruction);
        //记录操作日志
        if(check) setApprovalLog(bizDigitalConstruction);
        //添加围绕重点领域策划推出“一件事”情况
        if (bizDigitalConstruction.getBizDigitalOneThingList() != null && bizDigitalConstruction.getBizDigitalOneThingList().size() > 0) {
            List<BizDigitalOneThing> oneThingList = bizDigitalConstruction.getBizDigitalOneThingList();
            oneThingList.stream().forEach(t -> {

                if (t.getAuditStatus() != null ) {
                    if (bizDigitalConstruction.getStatus()!=null&&bizDigitalConstruction.getStatus()==4) {
                        //更新updateStatus字段
                        t.setUpdateStatus(0);
                        BizDigitalOneThing oneThing = bizDigitalOneThingManager.getOne(new QueryWrapper<BizDigitalOneThing>().eq("ORIGINAL_ID_", t.getOriginalId()).orderByDesc("CREATE_TIME_").last("LIMIT 1,1"));
                        if ((oneThing == null || oneThing.getIsBringInto() == null||(oneThing.getIsBringInto()!=null&&t.getTwoClassified() == null)) && t.getAuditStatus() != null&&t.getAuditStatus() != 4) {
                            if (t.getAuditStatus() == 3) {
                                t.setIsBringInto(0);
                                if (t.getAuditTime() == null) {
                                    t.setAuditTime(LocalDateTime.now());
                                }
                            } else {
                                t.setIsBringInto(null);
                                t.setAuditTime(null);
                            }
                        } else if (oneThing != null && oneThing.getIsBringInto() != null && t.getAuditStatus() != null&&t.getTwoClassified() != null&&t.getAuditStatus() != 4) {
                            if (oneThing.getIsBringInto()!=6&&(t.getAuditStatus() == 3 || t.getAuditStatus() == 6)) {
                                t.setIsBringInto(5);
                            }else if (t.getAuditStatus() != 3 && t.getAuditStatus() != 6&&t.getAuditStatus() != 4) {
                                  if (oneThing.getIsBringInto() == 0||oneThing.getIsBringInto() == 5) {
                                    t.setIsBringInto(1);
                                } else if (oneThing.getIsBringInto() == 1) {
                                    t.setIsBringInto(2);
                                }
                            }else if(oneThing.getIsBringInto()==6&&(t.getAuditStatus() == 3 || t.getAuditStatus() == 6)){
                                t.setIsBringInto(5);
                            }
                        }else if (t.getAuditStatus()!=null&&t.getAuditStatus() == 4) {
                            t.setIsBringInto(6);
                        }
//                    //第一次纳入晾晒
//                    if (bizDigitalConstruction.getStatus()==4&&(oneThing==null||oneThing.getIsBringInto()==null)&&t.getAuditStatus()!=4){
//                        if(t.getAuditStatus()==3){
//                            t.setIsBringInto(0);
//                            if (t.getAuditTime()==null){
//                                t.setAuditTime(LocalDateTime.now());
//                            }
//                        }else{
//                            t.setIsBringInto(null);
//                            t.setAuditTime(null);
//                        }
//                        //第一次纳入晾晒已通过后，再次更新,改革办通过则不在设置过期时间,未通过则记录一次驳回
//                    }else if (bizDigitalConstruction.getStatus()==4&&oneThing!=null&&oneThing.getIsBringInto()!=null&&(oneThing.getIsBringInto()==0||oneThing.getIsBringInto()==5||oneThing.getIsBringInto()==3)&&t.getAuditStatus()!=4&&t.getTwoClassified()!=null){
//                        if (t.getAuditStatus()==3||t.getAuditStatus()==6){
//                            t.setIsBringInto(5);
//                        }else{
//                            t.setIsBringInto(1);
//                        }
//                        //第一次纳入晾晒已通过后，再次更新,且存在一次驳回记录时,改革办通过则不在设置过期时间，未通过则记录一次驳回
//                    }else if (bizDigitalConstruction.getStatus()==4&&oneThing!=null&&oneThing.getIsBringInto()!=null&&oneThing.getIsBringInto()==1&&t.getAuditStatus()!=4&&t.getTwoClassified()!=null){
//                        if (t.getAuditStatus()==3||t.getAuditStatus()==6){
//                            t.setIsBringInto(5);
//                        }else{
//                            t.setIsBringInto(2);
//                        }
//                        //根据改革办审核情况,选择永不纳入晾晒,则移除晾晒库，且不设置过期时间
//                    }else if (bizDigitalConstruction.getStatus()==4&&t.getAuditStatus()==4){
//                        t.setIsBringInto(6);
//                    }
                    }
                }
                    bizDigitalOneThingManager.saveOrUpdate(t);
                    //更新附件
                    if (t.getFiles() != null && t.getFiles().size() > 0) {
                        List<String> ids = t.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                        universalWayManager.attachmentUpdates(ids, t.getId());
                    }
            });
        }
            //编制应用“三张清单”情况
            if (bizDigitalConstruction.getBizDigitalThreeListsList() != null && bizDigitalConstruction.getBizDigitalThreeListsList().size() > 0) {
                List<BizDigitalThreeLists> threeLists = bizDigitalConstruction.getBizDigitalThreeListsList();

                threeLists.stream().forEach(t -> {
                    if (bizDigitalConstruction.getStatus()==4){
                        if (t.getAuditStatus()==2&&t.getAuditTime()==null){
                            t.setAuditTime(LocalDateTime.now());
                        }else if (t.getAuditStatus()!=2){
                            t.setAuditTime(null);
                        }
                    }

                    //更新附件
                    if (t.getFiles() != null && t.getFiles().size() > 0) {
                        List<String> ids = t.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                        universalWayManager.attachmentUpdates(ids, t.getId());
                    }
                });
                bizDigitalThreeListsManager.saveOrUpdateBatch(threeLists);
            }

            //开发上线特色应用情况
            if (bizDigitalConstruction.getBizDigitalOnLineApplicationList() != null && bizDigitalConstruction.getBizDigitalOnLineApplicationList().size() > 0) {
                List<BizDigitalOnLineApplication> onLineApplicationList = bizDigitalConstruction.getBizDigitalOnLineApplicationList();
                onLineApplicationList.stream().forEach(t -> {
                    if (bizDigitalConstruction.getStatus()==4){
                        if (t.getAuditStatus()==2&&t.getAuditTime()==null){
                            t.setAuditTime(LocalDateTime.now());
                        }else if (t.getAuditStatus()!=2){
                            t.setAuditTime(null);
                        }
                    }
                    //更新附件
                    if (t.getFiles() != null && t.getFiles().size() > 0) {
                        List<String> ids = t.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                        universalWayManager.attachmentUpdates(ids, t.getId());
                    }
                });
                bizDigitalOnLineApplicationManager.saveOrUpdateBatch(onLineApplicationList);
            }
            //特色应用“一地创新、全市共享”情况
            if (bizDigitalConstruction.getBizDigitalShareApplicationList() != null && bizDigitalConstruction.getBizDigitalShareApplicationList().size() > 0) {
                List<BizDigitalShareApplication> shareApplicationList = bizDigitalConstruction.getBizDigitalShareApplicationList();

                shareApplicationList.stream().forEach(t -> {
                    //改革办确认时，根据审核情况，是否录入入库时间
                    if (bizDigitalConstruction.getStatus()==4){
                        if (t.getAuditStatus()==3&&t.getAuditTime()==null){
                            t.setAuditTime(LocalDateTime.now());
                        }else if (t.getAuditStatus()!=3){
                            t.setAuditTime(null);
                        }
                    }
                    //更新附件
                    if (t.getFiles() != null && t.getFiles().size() > 0) {
                        List<String> ids = t.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                        universalWayManager.attachmentUpdates(ids, t.getId());
                    }
                });
                bizDigitalShareApplicationManager.saveOrUpdateBatch(shareApplicationList);
            }
        return bizDigitalConstruction.getId() != null;
    }

    @Override
    public boolean invIsNew(String id,String unitId) {
        QueryWrapper<BizDigitalConstruction>queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("UNIT_ID_",unitId);
        queryWrapper.orderByDesc("CREATE_TIME_");
        queryWrapper.last("LIMIT 1");
        BizDigitalConstruction entity = this.getOne(queryWrapper);
        if (entity!=null)return entity.getId().equals(id);
        return true;
    }

    @Override
    public PageList<BizDigitalConstruction> queryByPage(QueryFilter<BizDigitalConstruction> queryFilter) {
        queryFilter.addFilter("o.ORG_KIND_","ogn", QueryOP.EQUAL);
        List<String> asList = Arrays.asList("2", "3", "4");
        queryFilter.addFilter("o.GRADE_",asList,QueryOP.IN);
        IPage<BizDigitalConstruction> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    public BizDigitalConstruction getByCreate(String id) {
        IUser user = ContextUtil.getCurrentUser();
        QueryWrapper<BizDigitalConstruction> queryWrapper = new QueryWrapper<>();
        if (BeanUtils.isEmpty(id)){
            queryWrapper.eq("UNIT_ID_", ContextUtil.getCurrentOrgId());
        }else {
            queryWrapper.eq("ID_", id);
        }
        queryWrapper.orderByDesc("CREATE_TIME_");
        queryWrapper.last("LIMIT 1");
        BizDigitalConstruction entity = super.getOne(queryWrapper);
        if (entity != null) {
            String eId = user != null && !user.isAdmin() ? entity.getUnitId() : null;
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalOneThing> oneThingList = bizDigitalOneThingManager.selectByUnitId(eId);
            entity.setBizDigitalOneThingList(oneThingList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalThreeLists> threeList = bizDigitalThreeListsManager.selectByUnitId(eId);
            entity.setBizDigitalThreeListsList(threeList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalOnLineApplication> onLineApplicationList = bizDigitalOnLineApplicationManager.selectByUnitId(eId);
            entity.setBizDigitalOnLineApplicationList(onLineApplicationList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalShareApplication> shareApplicationList = bizDigitalShareApplicationManager.selectByUnitId(eId);
            entity.setBizDigitalShareApplicationList(shareApplicationList);
        }
        return entity;
    }

    public BizDigitalConstruction getByAudit(String id) {
        QueryWrapper<BizDigitalConstruction> queryWrapper = new QueryWrapper<>();
        if (BeanUtils.isEmpty(id)){
            queryWrapper.eq("UNIT_ID_", ContextUtil.getCurrentOrgId());
        }else {
            queryWrapper.eq("ID_", id);
        }
        queryWrapper.orderByDesc("CREATE_TIME_");
        queryWrapper.last("LIMIT 1");
        BizDigitalConstruction entity = super.getOne(queryWrapper);
        if (entity != null) {
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalOneThing> oneThingList = bizDigitalOneThingManager.selectAuditById(entity.getId());
            entity.setBizDigitalOneThingList(oneThingList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalThreeLists> threeList = bizDigitalThreeListsManager.selectAuditById(entity.getId());
            entity.setBizDigitalThreeListsList(threeList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalOnLineApplication> onLineApplicationList = bizDigitalOnLineApplicationManager.selectAuditById(entity.getId());
            entity.setBizDigitalOnLineApplicationList(onLineApplicationList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalShareApplication> shareApplicationList = bizDigitalShareApplicationManager.selectAuditById(entity.getId());
            entity.setBizDigitalShareApplicationList(shareApplicationList);
        }
        return entity;
    }

    public BizDigitalConstruction getExamineById(String id) {
        QueryWrapper<BizDigitalConstruction> queryWrapper = new QueryWrapper<>();
        if (BeanUtils.isEmpty(id)){
            queryWrapper.eq("UNIT_ID_", ContextUtil.getCurrentOrgId());
        }else {
            queryWrapper.eq("ID_", id);
        }
        queryWrapper.orderByDesc("CREATE_TIME_");
        queryWrapper.last("LIMIT 1");
        BizDigitalConstruction entity = super.getOne(queryWrapper);
        if (entity != null) {
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalOneThing> oneThingList = bizDigitalOneThingManager.selectExamineById(entity.getId(),entity.getUnitId());
            entity.setBizDigitalOneThingList(oneThingList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalThreeLists> threeList = bizDigitalThreeListsManager.selectExamineById(entity.getId(),entity.getUnitId());
            entity.setBizDigitalThreeListsList(threeList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalOnLineApplication> onLineApplicationList = bizDigitalOnLineApplicationManager.selectExamineById(entity.getId(),entity.getUnitId());
            entity.setBizDigitalOnLineApplicationList(onLineApplicationList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalShareApplication> shareApplicationList = bizDigitalShareApplicationManager.selectExamineById(entity.getId(),entity.getUnitId());
            entity.setBizDigitalShareApplicationList(shareApplicationList);
        }
        return entity;
    }

    public BizDigitalConstruction getHisById(String unitId, LocalDateTime date,boolean isAffirm) {

        IUser user = ContextUtil.getCurrentUser();
        QueryWrapper<BizDigitalConstruction> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("UNIT_ID_",BeanUtils.isNotEmpty(unitId)?unitId:ContextUtil.getCurrentOrgId());
        queryWrapper.lt(BeanUtils.isNotEmpty(date),"CREATE_TIME_",date);
        queryWrapper.orderByDesc("CREATE_TIME_");
        queryWrapper.last(BeanUtils.isNotEmpty(date)?"LIMIT 1":"LIMIT 1,1");
        BizDigitalConstruction entity = super.getOne(queryWrapper);
        if (entity != null) {
            String eId = user != null && user.isAdmin()&&!isAffirm ? null : entity.getId();
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalOneThing> oneThingList = bizDigitalOneThingManager.selectAuditById(eId);
            entity.setBizDigitalOneThingList(oneThingList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalThreeLists> threeList = bizDigitalThreeListsManager.selectAuditById(eId);
            entity.setBizDigitalThreeListsList(threeList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalOnLineApplication> onLineApplicationList = bizDigitalOnLineApplicationManager.selectAuditById(eId);
            entity.setBizDigitalOnLineApplicationList(onLineApplicationList);
            //查询围绕重点领域策划推出“一件事”情况
            List<BizDigitalShareApplication> shareApplicationList = bizDigitalShareApplicationManager.selectAuditById(eId);
            entity.setBizDigitalShareApplicationList(shareApplicationList);
        }
        return entity;
    }

    @Transactional
    public void setApprovalLog(BizDigitalConstruction entity) {
        // 审批日志
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(entity.getId());
        logVo.setModeType(1);
        logVo.setModuleTableName("BIZ_DIGITAL_CONSTRUCTION");
        if (entity.getStatus() == 0) {
            logVo.setItemTitle("【推动数据重庆建设:" + entity.getUnitName() + "】保存为草稿");
            logVo.setApprovalResults(0);
            logVo.setOperateInfo("保存为草稿");
        } else if (entity.getStatus() == 1) {
            logVo.setItemTitle("【推动数据重庆建设:" + entity.getUnitName() + "】提交待审核");
            logVo.setApprovalResults(0);
            logVo.setOperateInfo("提交待审核");
        } else if (entity.getStatus() == 2) {
            logVo.setItemTitle("【推动数据重庆建设:" + entity.getUnitName() + "】区县审核员审核驳回");
            logVo.setApprovalResults(1);
            logVo.setOperateInfo("审核驳回");
        } else if (entity.getStatus() == 3) {
            logVo.setItemTitle("【推动数据重庆建设:" + entity.getUnitName() + "】区县审核员审核通过");
            logVo.setApprovalResults(0);
            logVo.setOperateInfo("审核通过");
        } else if (entity.getStatus() == 4) {
            logVo.setItemTitle("【推动数据重庆建设:" + entity.getUnitName() + "】改革办确认工单");
            logVo.setApprovalResults(0);
            logVo.setOperateInfo("确认工单");
        }
        logVo.setBizType("10");
        logVo.setStatus(entity.getStatus().toString());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    public boolean isExist(String pushId){
     BizDigitalAdvanceConstruction entity = bizDigitalAdvanceConstructionManager.getOne(new QueryWrapper<BizDigitalAdvanceConstruction>()
              .eq("PUSH_ID_", pushId).last("LIMIT 1"));
    return entity==null;
    }
}