package com.artfess.reform.fill.manager;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface UniversalWayManager {
    /**
     * 根据主表id更新附件表biz
     * @param bizId 业务ID
     */
    void attachmentUpdates(List<String> fileId, String bizId);

    /**
     * LocalTime类型时间获取年月季度
     * @param time
     * @return
     */
    Map<String,Integer> setLocalDate(LocalDate time);
    /**
     * Date类型时间获取年月季度
     * @param time
     * @return
     */
    Map<String,Integer> setDate(Date time);

    /**
     * 根据业务id删除文件
     * @param bizId
     */
     void deleteFiles(String bizId);
}
