package com.artfess.reform.fill.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizWorkNews;
import com.artfess.base.manager.BaseManager;

/**
 * 工作动态 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-04-07
 */
public interface BizWorkNewsManager extends BaseManager<BizWorkNews> {
    /**
     * 根据id删除所有数据
     * @param ids
     */
    void deleteInfo(String ids);

    /**
     * 添加或者修改实体类
     * @param bizWorkNews
     * @return
     */
    boolean saveOrUpdateEntity(BizWorkNews bizWorkNews);

    /**
     * 更新审核状态类
     * @param bizWorkNews
     * @return
     */
    boolean updateInfo(BizWorkNews bizWorkNews);

    /**
     * 工作台后台页面查询
     * @param queryFilter
     * @return
     */
    PageList<BizWorkNews> queryInfo(QueryFilter<BizWorkNews> queryFilter,boolean isAffirm);

    /**
     * 区县大屏查询
     * @param queryFilter
     * @return
     */
    PageList<BizWorkNews>  screenInfo(QueryFilter<BizWorkNews> queryFilter);
}
