package com.artfess.reform.fill.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizSpecialGroup;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 专项小组信息信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-05-15
 */
public interface BizSpecialGroupManager extends BaseManager<BizSpecialGroup> {
    /**
     * 保存或修改实体类
     * @return
     */
    boolean saveOrUpdateEntity(BizSpecialGroup bizSpecialGroup);

    /**
     * 删除数据
     */
    void deleteEntity(String id);
    /**
     * 根据id查询详情
     */
    BizSpecialGroup findById(String id);

    /**
     * 判断是否存在相同名称的专项小组
     */
    boolean isRepeat(String id,String name);

    /**
     * 专项小组信息分页查询
     * @param queryFilter
     * @return
     */
    PageList<BizSpecialGroup> queryPageList(QueryFilter<BizSpecialGroup> queryFilter);
}
